/*
 * Decompiled with CFR 0.152.
 */
package com.duzo.fakeplayers.networking;

import com.duzo.fakeplayers.networking.packets.SendHumanoidChatC2SPacket;
import com.duzo.fakeplayers.networking.packets.SendImageDownloadMessageS2CPacket;
import com.duzo.fakeplayers.networking.packets.SendSkinMessageS2CPacket;
import com.duzo.fakeplayers.networking.packets.UpdateHumanoidAIC2SPacket;
import com.duzo.fakeplayers.networking.packets.UpdateHumanoidSittingC2SPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Network {
    private static SimpleChannel INSTANCE;
    private static final Logger LOGGER;
    private static int packetId;

    private static int id() {
        return packetId++;
    }

    public static void register() {
        SimpleChannel net;
        INSTANCE = net = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("fakeplayers", "messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
        net.messageBuilder(SendImageDownloadMessageS2CPacket.class, Network.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(SendImageDownloadMessageS2CPacket::decode).encoder(SendImageDownloadMessageS2CPacket::encode).consumerMainThread(SendImageDownloadMessageS2CPacket::handle).add();
        net.messageBuilder(SendSkinMessageS2CPacket.class, Network.id(), NetworkDirection.PLAY_TO_CLIENT).decoder(SendSkinMessageS2CPacket::decode).encoder(SendSkinMessageS2CPacket::encode).consumerMainThread(SendSkinMessageS2CPacket::handle).add();
        net.messageBuilder(UpdateHumanoidAIC2SPacket.class, Network.id(), NetworkDirection.PLAY_TO_SERVER).decoder(UpdateHumanoidAIC2SPacket::decode).encoder(UpdateHumanoidAIC2SPacket::encode).consumerMainThread(UpdateHumanoidAIC2SPacket::handle).add();
        net.messageBuilder(SendHumanoidChatC2SPacket.class, Network.id(), NetworkDirection.PLAY_TO_SERVER).decoder(SendHumanoidChatC2SPacket::decode).encoder(SendHumanoidChatC2SPacket::encode).consumerMainThread(SendHumanoidChatC2SPacket::handle).add();
        net.messageBuilder(UpdateHumanoidSittingC2SPacket.class, Network.id(), NetworkDirection.PLAY_TO_SERVER).decoder(UpdateHumanoidSittingC2SPacket::decode).encoder(UpdateHumanoidSittingC2SPacket::encode).consumerMainThread(UpdateHumanoidSittingC2SPacket::handle).add();
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToAll(MSG message) {
        if (INSTANCE != null && message != null) {
            try {
                INSTANCE.send(PacketDistributor.ALL.noArg(), message);
            }
            catch (NullPointerException e) {
                LOGGER.warn("Failed to send message to all players.");
            }
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        packetId = 0;
    }
}

