/*
 * Decompiled with CFR 0.152.
 */
package com.duzo.fakeplayers.common.entities.humanoids;

import com.duzo.fakeplayers.common.entities.HumanoidEntity;
import com.duzo.fakeplayers.common.goals.MoveTowardsItemsGoal;
import com.duzo.fakeplayers.configs.FPCommonConfigs;
import com.duzo.fakeplayers.core.init.FPItems;
import com.duzo.fakeplayers.events.FakePlayersClientEvents;
import com.duzo.fakeplayers.networking.Network;
import com.duzo.fakeplayers.networking.packets.SendImageDownloadMessageS2CPacket;
import com.duzo.fakeplayers.util.SkinGrabber;
import java.io.File;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeSpawnEggItem;
import org.jetbrains.annotations.Nullable;

public class FakePlayerEntity
extends HumanoidEntity {
    private static final EntityDataAccessor<String> SKIN_URL = SynchedEntityData.m_135353_(FakePlayerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private boolean forceTarget = false;
    private LivingEntity target;

    public FakePlayerEntity(EntityType<? extends FakePlayerEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21553_(true);
    }

    public FakePlayerEntity(EntityType<? extends FakePlayerEntity> entityType, Level level, String customName, ResourceLocation skin) {
        super(entityType, level, customName, skin);
        this.m_21553_(true);
    }

    public FakePlayerEntity(EntityType<? extends FakePlayerEntity> entityType, Level level, String customName) {
        super(entityType, level, customName);
        this.m_21553_(true);
    }

    public FakePlayerEntity(EntityType<? extends FakePlayerEntity> entityType, Level level, ResourceLocation skin) {
        super(entityType, level, skin);
        this.m_21553_(true);
    }

    protected void m_7472_(DamageSource p_21385_, int p_21386_, boolean p_21387_) {
        super.m_7472_(p_21385_, p_21386_, p_21387_);
        if (!((Boolean)FPCommonConfigs.DOES_DROP_EGGS.get()).booleanValue()) {
            return;
        }
        ItemStack egg = this.getEgg();
        egg.m_41714_(this.m_7770_());
        this.m_19983_(egg);
    }

    public ItemStack getEgg() {
        return ((ForgeSpawnEggItem)FPItems.FAKE_PLAYER_SPAWN_EGG.get()).m_7968_();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MoveTowardsItemsGoal(this, 1.0, true));
        super.m_8099_();
    }

    @Override
    public void m_6593_(@Nullable Component customName) {
        super.m_6593_(customName);
        if (!this.m_9236_().m_5776_()) {
            if (customName.getString().equals("")) {
                return;
            }
            this.setURL("https://mineskin.eu/skin/" + customName.getString());
            this.updateSkin();
        }
    }

    public void toggleAI(Player player) {
        this.m_21557_(!this.m_21525_());
        player.m_213846_((Component)Component.m_237113_((String)(this.m_7755_().getString() + " AI has been set to: " + !this.m_21525_())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.LIGHT_PURPLE)));
    }

    public static void downloadAndAddSkin(String name, Entity entity) {
        SkinGrabber.downloadSkinFromUsername(name.toLowerCase().replace(" ", ""), new File("./fakeplayers/skins/"));
        SkinGrabber.addEntityToList(entity);
    }

    private void openSkinScreen(Player player) {
        Minecraft.m_91087_().m_91152_(FakePlayersClientEvents.createSkinScreen((Component)Component.m_237115_((String)"screen.fakeplayers.skin"), this, player));
    }

    public String getURL() {
        return (String)this.f_19804_.m_135370_(SKIN_URL);
    }

    public void setURL(String URL2) {
        this.f_19804_.m_135381_(SKIN_URL, (Object)URL2);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("URL", this.getURL());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(SKIN_URL, (Object)nbt.m_128461_("URL"));
        this.setURL(nbt.m_128461_("URL"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SKIN_URL, (Object)"");
    }

    public void updateSkin() {
        Network.sendToAll(new SendImageDownloadMessageS2CPacket(this.m_20149_(), this.m_20149_(), new File("./fakeplayers/skins/"), this.getURL()));
    }

    public void setForceTargeting(boolean forceTargeting) {
        this.forceTarget = forceTargeting;
    }

    public void setForceTargeting(LivingEntity entity) {
        this.forceTarget = true;
        this.target = entity;
    }

    public void sendChat(String message) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.m_20194_().m_6846_().m_243063_(PlayerChatMessage.m_247306_((String)message), this.m_20203_(), ChatType.m_240980_((ResourceKey)ChatType.f_130598_, (Entity)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !this.m_21525_() && this.forceTarget && this.target != null && this.m_5448_() != this.target) {
            this.m_21573_().m_5624_((Entity)this.target, 2.0);
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && player.m_6047_()) {
            if (this.m_9236_().f_46443_) {
                this.openSkinScreen(player);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

