/*
 * Decompiled with CFR 0.152.
 */
package com.duzo.fakeplayers.common.entities;

import com.duzo.fakeplayers.common.goals.HumanoidWaterAvoidingRandomStrollGoal;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;

public abstract class HumanoidEntity
extends PathfinderMob {
    public static final ResourceLocation ERROR_TEXTURE = new ResourceLocation("fakeplayers", "textures/entities/humanoid/error.png");
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(HumanoidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public String customName = "";
    public ResourceLocation skin = ERROR_TEXTURE;
    private Inventory inventory;

    public HumanoidEntity(EntityType<? extends HumanoidEntity> entityType, Level level) {
        super(entityType, level);
        this.m_6593_((Component)Component.m_237115_((String)this.customName));
        this.m_20340_(true);
    }

    public HumanoidEntity(EntityType<? extends HumanoidEntity> entityType, Level level, String customName, ResourceLocation skin) {
        this(entityType, level);
        this.customName = customName;
        this.skin = skin;
        this.m_6593_((Component)Component.m_237115_((String)this.customName));
    }

    public HumanoidEntity(EntityType<? extends HumanoidEntity> entityType, Level level, String customName) {
        this(entityType, level);
        this.customName = customName;
        this.skin = ERROR_TEXTURE;
        this.m_6593_((Component)Component.m_237115_((String)this.customName));
    }

    public HumanoidEntity(EntityType<? extends HumanoidEntity> entityType, Level level, ResourceLocation skin) {
        this(entityType, level);
        this.skin = skin;
        this.m_6593_((Component)Component.m_237115_((String)this.customName));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new HumanoidWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation navigator = new GroundPathNavigation((Mob)this, level);
        navigator.m_7008_(true);
        navigator.m_26477_(true);
        return navigator;
    }

    public void m_6593_(@Nullable Component customName) {
        if (customName == null) {
            return;
        }
        super.m_6593_(customName);
        this.customName = ChatFormatting.m_126649_((String)this.m_7755_().getString());
    }

    public ResourceLocation getSkin() {
        return this.skin;
    }

    public static AttributeSupplier.Builder getHumanoidAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 1.0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("sitting", this.isSitting());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(SITTING, (Object)nbt.m_128471_("sitting"));
        this.setSitting(nbt.m_128471_("sitting"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SITTING, (Object)false);
    }

    public void sit() {
        this.setSitting(true);
    }

    public void stand() {
        this.setSitting(false);
    }

    public void toggleSit() {
        this.setSitting(!this.isSitting());
    }

    public void setSitting(boolean val) {
        this.f_19804_.m_135381_(SITTING, (Object)val);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }
}

