/*
 * Decompiled with CFR 0.152.
 */
package com.duzo.fakeplayers.client.screens;

import com.duzo.fakeplayers.common.entities.humanoids.FakePlayerEntity;
import com.duzo.fakeplayers.configs.FPClientConfigs;
import com.duzo.fakeplayers.networking.Network;
import com.duzo.fakeplayers.networking.packets.SendHumanoidChatC2SPacket;
import com.duzo.fakeplayers.networking.packets.UpdateHumanoidAIC2SPacket;
import com.duzo.fakeplayers.networking.packets.UpdateHumanoidSittingC2SPacket;
import com.duzo.fakeplayers.util.SkinGrabber;
import java.io.File;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class FPSkinScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("fakeplayers", "textures/gui/skin_select.png");
    private FakePlayerEntity humanoid;
    private Player player;
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    private EditBox input;
    private EditBox chatBox;
    private Button confirm;
    private Button send;
    private Button stayPut;
    private Button follow;
    private Button wander;
    private Button sitting;

    public FPSkinScreen(Component component, FakePlayerEntity humanoid, Player player) {
        super(component);
        this.humanoid = humanoid;
        this.player = player;
        if (this.f_96541_ == null) {
            this.f_96541_ = this.getMinecraft();
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int l = (this.f_96544_ - this.imageHeight) / 2 + (int)((double)this.imageHeight * 0.05);
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = this.imageWidth - (int)((double)this.imageWidth * 0.1);
        assert (this.f_96541_ != null);
        this.input = new EditBox(this.f_96541_.f_243022_, i + this.imageWidth / 2 - j + j / 2, l, j, 12, (Component)Component.m_237115_((String)"screen.fakeplayers.skin"));
        this.input.m_94144_(this.humanoid.getURL());
        this.input.m_94199_(100);
        this.input.m_94182_(true);
        this.m_7787_((GuiEventListener)this.input);
        if (((Boolean)FPClientConfigs.USES_FILES.get()).booleanValue()) {
            this.input.m_94144_("PUT FILE PATH HERE!");
        }
        int after_input_edit_box_y = this.input.m_252907_() + this.input.m_93694_() + (int)((double)this.f_96544_ * 0.01);
        this.chatBox = new EditBox(this.f_96541_.f_243022_, i + this.imageWidth / 2 - j + j / 2, after_input_edit_box_y, j, 12, (Component)Component.m_237115_((String)"screen.fakeplayers.chatbox"));
        this.chatBox.m_94144_("Input chat message here!");
        this.chatBox.m_94186_(true);
        this.chatBox.m_94199_(100);
        this.chatBox.m_94182_(true);
        this.m_7787_((GuiEventListener)this.chatBox);
        int after_chat_edit_box_y = this.chatBox.m_252907_() + this.chatBox.m_93694_() + (int)((double)this.f_96544_ * 0.02);
        this.send = new Button.Builder((Component)Component.m_237115_((String)"screens.fakeplayers.send"), p_96786_ -> this.pressSendChatButton()).m_252987_(i + this.imageWidth / 2 - 49, after_chat_edit_box_y, 98, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.send);
        int after_send_button_y = this.send.m_252907_() + this.send.m_93694_() + (int)((double)this.f_96544_ * 0.05);
        this.sitting = new Button.Builder((Component)Component.m_237115_((String)"screens.fakeplayers.sit"), p_96786_ -> this.pressToggleSit()).m_252987_(i + this.imageWidth / 2 - 23, after_send_button_y, 46, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.sitting);
        int after_sitting_button_y = this.sitting.m_252907_() + this.sitting.m_93694_();
        this.stayPut = new Button.Builder((Component)Component.m_237115_((String)"screens.fakeplayers.stayPut"), p_96786_ -> this.pressStayPut()).m_252987_(i + this.imageWidth / 2 - 23, after_sitting_button_y, 46, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.stayPut);
        this.wander = new Button.Builder((Component)Component.m_237115_((String)"screens.fakeplayers.wander"), p_96786_ -> this.pressWanderButton()).m_252987_(i + this.imageWidth / 2 - 69, after_sitting_button_y, 46, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.wander);
        this.follow = new Button.Builder((Component)Component.m_237115_((String)"screens.fakeplayers.follow"), p_96786_ -> this.pressFollowButton()).m_252987_(i + this.imageWidth / 2 + 23, after_sitting_button_y, 46, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.follow);
        int after_other_buttons_y = this.follow.m_252907_() + this.follow.m_93694_() + (int)((double)this.f_96544_ * 0.02);
        this.confirm = new Button.Builder((Component)Component.m_237115_((String)"screens.fakeplayers.done"), p_96786_ -> this.pressDoneButton()).m_252987_(i + this.imageWidth / 2 - 49, after_other_buttons_y, 98, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.confirm);
    }

    private void updateEntityURL() {
        this.humanoid.setURL(this.input.m_94155_());
    }

    private void pressDoneButton() {
        if (!((Boolean)FPClientConfigs.USES_FILES.get()).booleanValue()) {
            this.updateEntityURL();
            this.humanoid.updateSkin();
        } else {
            File skinDir = new File(this.input.m_94155_());
            if (skinDir.exists()) {
                ResourceLocation location = SkinGrabber.fileToLocation(skinDir);
                SkinGrabber.SKIN_LIST.replace(this.humanoid.m_20149_(), location);
            }
        }
        this.m_7379_();
    }

    private void pressSendChatButton() {
        Network.sendToServer(new SendHumanoidChatC2SPacket(this.humanoid.m_20148_(), this.chatBox.m_94155_()));
    }

    private void pressToggleSit() {
        this.sitting.f_93623_ = true;
        this.stayPut.f_93623_ = true;
        this.follow.f_93623_ = true;
        this.wander.f_93623_ = true;
        this.humanoid.toggleSit();
        Network.sendToServer(new UpdateHumanoidSittingC2SPacket(this.humanoid.m_20148_(), this.humanoid.isSitting()));
    }

    private void pressStayPut() {
        this.sitting.f_93623_ = true;
        this.stayPut.f_93623_ = false;
        this.follow.f_93623_ = true;
        this.wander.f_93623_ = true;
        this.humanoid.m_21557_(true);
        this.humanoid.setForceTargeting(false);
        Network.sendToServer(new UpdateHumanoidAIC2SPacket(this.humanoid.m_20148_(), true, false, false));
    }

    private void pressWanderButton() {
        this.stayPut.f_93623_ = true;
        this.follow.f_93623_ = true;
        this.wander.f_93623_ = false;
        this.sitting.f_93623_ = true;
        this.humanoid.m_21557_(false);
        this.humanoid.setForceTargeting(false);
        Network.sendToServer(new UpdateHumanoidAIC2SPacket(this.humanoid.m_20148_(), false, false, false));
    }

    private void pressFollowButton() {
        this.stayPut.f_93623_ = true;
        this.sitting.f_93623_ = true;
        this.follow.f_93623_ = false;
        this.wander.f_93623_ = true;
        this.humanoid.m_21557_(false);
        this.humanoid.setForceTargeting((LivingEntity)this.player);
        Network.sendToServer(new UpdateHumanoidAIC2SPacket(this.humanoid.m_20148_(), false, true, true));
    }

    public void m_88315_(GuiGraphics pPoseStack, int mouseX, int mouseY, float delta) {
        this.renderBg(pPoseStack);
        super.m_88315_(pPoseStack, mouseX, mouseY, delta);
        if (this.input != null && this.confirm != null) {
            this.input.m_88315_(pPoseStack, mouseX, mouseY, delta);
            this.chatBox.m_88315_(pPoseStack, mouseX, mouseY, delta);
        }
    }

    public void renderBg(GuiGraphics p_96557_) {
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        p_96557_.m_280218_(GUI_TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }
}

