/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.util;

import java.util.Locale;
import net.minecraft.util.Mth;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public final class FluidUtils {
    private static final String[] FLUID_PREFIXES = new String[]{"", "k", "M", "G", "T", "P"};

    private FluidUtils() {
    }

    public static String getFluidAmountWithPrefix(int fluidAmount) {
        if (fluidAmount < 1000) {
            return String.format(Locale.ENGLISH, "%d mB", fluidAmount);
        }
        double fluidAmountWithPrefix = fluidAmount;
        int prefixIndex = 0;
        while ((int)fluidAmountWithPrefix >= 1000 && prefixIndex + 1 < FLUID_PREFIXES.length) {
            fluidAmountWithPrefix /= 1000.0;
            ++prefixIndex;
        }
        return String.format(Locale.ENGLISH, "%.2f%s mB", fluidAmountWithPrefix, FLUID_PREFIXES[prefixIndex]);
    }

    public static int getRedstoneSignalFromFluidHandler(IFluidHandler fluidHandler) {
        float fullnessPercentSum = 0.0f;
        boolean isEmptyFlag = true;
        int size = fluidHandler.getTanks();
        for (int i = 0; i < size; ++i) {
            FluidStack fluid = fluidHandler.getFluidInTank(i);
            if (fluid.isEmpty()) continue;
            fullnessPercentSum += (float)fluid.getAmount() / (float)fluidHandler.getTankCapacity(i);
            isEmptyFlag = false;
        }
        return Math.min(Mth.m_14143_((float)(fullnessPercentSum / (float)size * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
    }
}

