/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen.base;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.ChangeCurrentRecipeIndexC2SPacket;
import me.jddev0.ep.screen.base.ConfigurableUpgradableEnergyStorageContainerScreen;
import me.jddev0.ep.screen.base.IConfigurableMenu;
import me.jddev0.ep.screen.base.ISelectableRecipeMachineMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class SelectableRecipeMachineContainerScreen<R extends Recipe<?>, T extends AbstractContainerMenu & IConfigurableMenu>
extends ConfigurableUpgradableEnergyStorageContainerScreen<T> {
    protected int recipeSelectorPosX = 80;
    protected int recipeSelectorPosY = 17;
    protected int recipeSelectorTexturePosX = 176;
    protected int recipeSelectorTexturePosY = 70;

    public SelectableRecipeMachineContainerScreen(T menu, Inventory inventory, Component titleComponent, ResourceLocation texture, ResourceLocation upgradeViewTexture) {
        super(menu, inventory, titleComponent, texture, upgradeViewTexture);
    }

    public SelectableRecipeMachineContainerScreen(T menu, Inventory inventory, Component titleComponent, String energyIndicatorBarTooltipComponentID, ResourceLocation texture, ResourceLocation upgradeViewTexture) {
        super(menu, inventory, titleComponent, energyIndicatorBarTooltipComponentID, texture, upgradeViewTexture);
    }

    protected abstract ItemStack getRecipeIcon(R var1);

    protected abstract void renderCurrentRecipeTooltip(GuiGraphics var1, int var2, int var3, R var4);

    @Override
    protected boolean mouseClickedNormalView(double mouseX, double mouseY, int mouseButton) {
        if (super.mouseClickedNormalView(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0) {
            int diff = 0;
            if (this.m_6774_(this.recipeSelectorPosX - 13, this.recipeSelectorPosY + 2, 11, 12, mouseX, mouseY)) {
                diff = -1;
            }
            if (this.m_6774_(this.recipeSelectorPosX + 18, this.recipeSelectorPosY + 2, 11, 12, mouseX, mouseY)) {
                diff = 1;
            }
            if (diff != 0) {
                ModMessages.sendToServer(new ChangeCurrentRecipeIndexC2SPacket(((IConfigurableMenu)this.f_97732_).getBlockEntity().m_58899_(), diff == 1));
                return true;
            }
        }
        return false;
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderCurrentRecipeOutput(guiGraphics, x, y);
        this.renderButtons(guiGraphics, x, y, mouseX, mouseY);
    }

    private void renderCurrentRecipeOutput(GuiGraphics guiGraphics, int x, int y) {
        Object currentRecipe = ((ISelectableRecipeMachineMenu)this.f_97732_).getCurrentRecipe();
        if (currentRecipe == null) {
            return;
        }
        ItemStack itemStackIcon = this.getRecipeIcon(currentRecipe);
        if (!itemStackIcon.m_41619_()) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            guiGraphics.m_280256_(itemStackIcon, x + this.recipeSelectorPosX, y + this.recipeSelectorPosY, this.recipeSelectorPosX + this.recipeSelectorPosY * this.f_97726_);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.m_6774_(this.recipeSelectorPosX - 13, this.recipeSelectorPosY + 2, 11, 12, mouseX, mouseY)) {
            guiGraphics.m_280218_(this.TEXTURE, x + this.recipeSelectorPosX - 13, y + this.recipeSelectorPosY + 2, this.recipeSelectorTexturePosX, this.recipeSelectorTexturePosY, 11, 12);
        }
        if (this.m_6774_(this.recipeSelectorPosX + 18, this.recipeSelectorPosY + 2, 11, 12, mouseX, mouseY)) {
            guiGraphics.m_280218_(this.TEXTURE, x + this.recipeSelectorPosX + 18, y + this.recipeSelectorPosY + 2, this.recipeSelectorTexturePosX + 11, this.recipeSelectorTexturePosY, 11, 12);
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components;
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        Object currentRecipe = ((ISelectableRecipeMachineMenu)this.f_97732_).getCurrentRecipe();
        if (currentRecipe != null && this.m_6774_(this.recipeSelectorPosX, this.recipeSelectorPosY, 16, 16, mouseX, mouseY)) {
            this.renderCurrentRecipeTooltip(guiGraphics, mouseX, mouseY, currentRecipe);
        }
        if (this.m_6774_(this.recipeSelectorPosX - 13, this.recipeSelectorPosY + 2, 11, 12, mouseX, mouseY)) {
            components = new ArrayList<MutableComponent>(2);
            components.add(Component.m_237115_((String)"tooltip.energizedpower.recipe.selector.prev_recipe"));
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.m_6774_(this.recipeSelectorPosX + 18, this.recipeSelectorPosY + 2, 11, 12, mouseX, mouseY)) {
            components = new ArrayList(2);
            components.add(Component.m_237115_((String)"tooltip.energizedpower.recipe.selector.next_recipe"));
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

