/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen.base;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.screen.base.EnergizedPowerBaseContainerScreen;
import me.jddev0.ep.screen.base.IEnergyStorageMenu;
import me.jddev0.ep.screen.base.IUpgradeModuleMenu;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class EnergyStorageContainerScreen<T extends AbstractContainerMenu>
extends EnergizedPowerBaseContainerScreen<T> {
    protected final ResourceLocation TEXTURE;
    protected int energyMeterX = 8;
    protected int energyMeterY = 17;
    protected int energyMeterWidth = 16;
    protected int energyMeterHeight = 52;
    protected int energyMeterU = 176;
    protected int energyMeterV = 0;
    protected final String energyIndicatorBarTooltipComponentID;

    public EnergyStorageContainerScreen(T menu, Inventory inventory, Component titleComponent) {
        this(menu, inventory, titleComponent, (String)null);
    }

    public EnergyStorageContainerScreen(T menu, Inventory inventory, Component titleComponent, String energyIndicatorBarTooltipComponentID) {
        this(menu, inventory, titleComponent, energyIndicatorBarTooltipComponentID, EPAPI.id("textures/gui/container/generic_energy.png"));
    }

    public EnergyStorageContainerScreen(T menu, Inventory inventory, Component titleComponent, ResourceLocation texture) {
        this(menu, inventory, titleComponent, null, texture);
    }

    public EnergyStorageContainerScreen(T menu, Inventory inventory, Component titleComponent, String energyIndicatorBarTooltipComponentID, ResourceLocation texture) {
        super(menu, inventory, titleComponent);
        this.TEXTURE = texture;
        this.energyIndicatorBarTooltipComponentID = energyIndicatorBarTooltipComponentID;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (!((IUpgradeModuleMenu)this.f_97732_).isInUpgradeModuleView()) {
            guiGraphics.m_280218_(this.TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
            this.renderEnergyMeter(guiGraphics, x, y);
            this.renderEnergyIndicatorBar(guiGraphics, x, y);
        }
    }

    protected void renderEnergyMeter(GuiGraphics guiGraphics, int x, int y) {
        int pos = ((IEnergyStorageMenu)this.f_97732_).getScaledEnergyMeterPos(this.energyMeterHeight);
        guiGraphics.m_280218_(this.TEXTURE, x + this.energyMeterX, y + this.energyMeterY + this.energyMeterHeight - pos, this.energyMeterU, this.energyMeterV + this.energyMeterHeight - pos, this.energyMeterWidth, pos);
    }

    protected void renderEnergyIndicatorBar(GuiGraphics guiGraphics, int x, int y) {
        int pos = ((IEnergyStorageMenu)this.f_97732_).getScaledEnergyIndicatorBarPos(this.energyMeterHeight);
        if (pos > 0) {
            guiGraphics.m_280218_(this.TEXTURE, x + this.energyMeterX, y + this.energyMeterY + this.energyMeterHeight - pos, this.energyMeterU, this.energyMeterV + this.energyMeterHeight, this.energyMeterWidth, 1);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (!((IUpgradeModuleMenu)this.f_97732_).isInUpgradeModuleView() && this.m_6774_(this.energyMeterX, this.energyMeterY, this.energyMeterWidth, this.energyMeterHeight, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.m_237110_((String)"tooltip.energizedpower.energy_meter.content.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(((IEnergyStorageMenu)this.f_97732_).getEnergy()), EnergyUtils.getEnergyWithPrefix(((IEnergyStorageMenu)this.f_97732_).getCapacity())}));
            if (((IEnergyStorageMenu)this.f_97732_).getEnergyIndicatorBarValue() > 0 && this.energyIndicatorBarTooltipComponentID != null) {
                components.add(Component.m_237110_((String)this.energyIndicatorBarTooltipComponentID, (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(((IEnergyStorageMenu)this.f_97732_).getEnergyIndicatorBarValue())}).m_130940_(ChatFormatting.YELLOW));
            }
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

