/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen.base;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class EnergizedPowerBaseContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public EnergizedPowerBaseContainerScreen(T menu, Inventory inventory, Component titleComponent) {
        super(menu, inventory, titleComponent);
    }

    protected void renderFluidMeterContent(GuiGraphics guiGraphics, FluidStack fluidStack, int tankCapacity, int x, int y, int w, int h) {
        RenderSystem.enableBlend();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        this.renderFluidStack(guiGraphics, fluidStack, tankCapacity, w, h);
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void renderFluidStack(GuiGraphics guiGraphics, FluidStack fluidStack, int tankCapacity, int w, int h) {
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation stillFluidImageId = fluidTypeExtensions.getStillTexture(fluidStack);
        if (stillFluidImageId == null) {
            stillFluidImageId = new ResourceLocation("air");
        }
        TextureAtlasSprite stillFluidSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillFluidImageId);
        int fluidColorTint = fluidTypeExtensions.getTintColor(fluidStack);
        int fluidMeterPos = tankCapacity == -1 || fluidStack.getAmount() > 0 && fluidStack.getAmount() == tankCapacity ? 0 : h - (fluidStack.getAmount() <= 0 || tankCapacity == 0 ? 0 : Math.min(fluidStack.getAmount(), tankCapacity - 1) * h / tankCapacity + 1);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)((float)(fluidColorTint >> 16 & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 8 & 0xFF) / 255.0f), (float)((float)(fluidColorTint & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 24 & 0xFF) / 255.0f));
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        for (int yOffset = h; yOffset > fluidMeterPos; yOffset -= 16) {
            for (int xOffset = 0; xOffset < w; xOffset += 16) {
                int width = Math.min(w - xOffset, 16);
                int height = Math.min(yOffset - fluidMeterPos, 16);
                float u0 = stillFluidSprite.m_118409_();
                float u1 = stillFluidSprite.m_118410_();
                float v0 = stillFluidSprite.m_118411_();
                float v1 = stillFluidSprite.m_118412_();
                u1 -= (float)(16 - width) / 16.0f * (u1 - u0);
                v0 -= (float)(16 - height) / 16.0f * (v0 - v1);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferBuilder = tesselator.m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferBuilder.m_252986_(mat, (float)xOffset, (float)yOffset, 0.0f).m_7421_(u0, v1).m_5752_();
                bufferBuilder.m_252986_(mat, (float)(xOffset + width), (float)yOffset, 0.0f).m_7421_(u1, v1).m_5752_();
                bufferBuilder.m_252986_(mat, (float)(xOffset + width), (float)(yOffset - height), 0.0f).m_7421_(u1, v0).m_5752_();
                bufferBuilder.m_252986_(mat, (float)xOffset, (float)(yOffset - height), 0.0f).m_7421_(u0, v0).m_5752_();
                tesselator.m_85914_();
            }
        }
    }
}

