/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.recipe.StoneSolidifierRecipe;
import me.jddev0.ep.screen.StoneSolidifierMenu;
import me.jddev0.ep.screen.base.SelectableRecipeMachineContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StoneSolidifierScreen
extends SelectableRecipeMachineContainerScreen<StoneSolidifierRecipe, StoneSolidifierMenu> {
    public StoneSolidifierScreen(StoneSolidifierMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", EPAPI.id("textures/gui/container/stone_solidifier.png"), EPAPI.id("textures/gui/container/upgrade_view/1_speed_1_energy_efficiency_1_energy_capacity.png"));
        this.recipeSelectorPosX = 98;
        this.recipeSelectorTexturePosY = 135;
    }

    @Override
    protected ItemStack getRecipeIcon(StoneSolidifierRecipe currentRecipe) {
        return currentRecipe.getOutput();
    }

    @Override
    protected void renderCurrentRecipeTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, StoneSolidifierRecipe currentRecipe) {
        ItemStack output = currentRecipe.getOutput();
        if (!output.m_41619_()) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.m_237110_((String)"tooltip.energizedpower.count_with_item.txt", (Object[])new Object[]{output.m_41613_(), output.m_41786_()}));
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        for (int i = 0; i < 2; ++i) {
            this.renderFluidMeterContent(guiGraphics, ((StoneSolidifierMenu)this.f_97732_).getFluid(i), ((StoneSolidifierMenu)this.f_97732_).getTankCapacity(i), x + (i == 0 ? 44 : 152), y + 17, 16, 52);
            this.renderFluidMeterOverlay(i, guiGraphics, x, y);
        }
        this.renderProgressArrows(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(int tank, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280218_(this.TEXTURE, x + (tank == 0 ? 44 : 152), y + 17, 176, 53, 16, 52);
    }

    private void renderProgressArrows(GuiGraphics guiGraphics, int x, int y) {
        if (((StoneSolidifierMenu)this.f_97732_).isCraftingActive()) {
            guiGraphics.m_280218_(this.TEXTURE, x + 69, y + 45, 176, 106, ((StoneSolidifierMenu)this.f_97732_).getScaledProgressArrowSize(), 14);
            guiGraphics.m_280218_(this.TEXTURE, x + 143 - ((StoneSolidifierMenu)this.f_97732_).getScaledProgressArrowSize(), y + 45, 196 - ((StoneSolidifierMenu)this.f_97732_).getScaledProgressArrowSize(), 120, ((StoneSolidifierMenu)this.f_97732_).getScaledProgressArrowSize(), 14);
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        for (int i = 0; i < 2; ++i) {
            if (!this.m_6774_(i == 0 ? 44 : 152, 17, 16, 52, mouseX, mouseY)) continue;
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((StoneSolidifierMenu)this.f_97732_).getFluid(i).isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((StoneSolidifierMenu)this.f_97732_).getFluid(i).getAmount();
            MutableComponent tooltipComponent = Component.m_237110_((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((StoneSolidifierMenu)this.f_97732_).getTankCapacity(i))});
            if (!fluidEmpty) {
                tooltipComponent = Component.m_237115_((String)((StoneSolidifierMenu)this.f_97732_).getFluid(i).getTranslationKey()).m_130946_(" ").m_7220_((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

