/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.inventory.ConstraintInsertSlot;
import me.jddev0.ep.item.InventoryChargerItem;
import me.jddev0.ep.screen.EPMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class InventoryChargerMenu
extends AbstractContainerMenu {
    private final Container container;
    private final Level level;

    public InventoryChargerMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, (Container)new SimpleContainer(InventoryChargerItem.SLOT_COUNT){

            public boolean m_7013_(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < this.m_6643_()) {
                    LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                    if (!energyStorageLazyOptional.isPresent()) {
                        return false;
                    }
                    IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
                    return energyStorage.canExtract();
                }
                return super.m_7013_(slot, stack);
            }

            public int m_6893_() {
                return 1;
            }
        });
    }

    public InventoryChargerMenu(int id, Inventory inv, Container container) {
        super((MenuType)EPMenuTypes.INVENTORY_CHARGER_MENU.get(), id);
        InventoryChargerMenu.m_38869_((Container)inv, (int)InventoryChargerItem.SLOT_COUNT);
        this.container = container;
        this.level = inv.f_35978_.m_9236_();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        int slotIndex = 0;
        if (container.m_6643_() >= 5) {
            this.m_38897_(new ConstraintInsertSlot(container, slotIndex++, 44, 35));
        }
        if (container.m_6643_() >= 3) {
            this.m_38897_(new ConstraintInsertSlot(container, slotIndex++, 62, 35));
        }
        if (container.m_6643_() >= 1) {
            this.m_38897_(new ConstraintInsertSlot(container, slotIndex++, 80, 35));
        }
        if (container.m_6643_() >= 3) {
            this.m_38897_(new ConstraintInsertSlot(container, slotIndex++, 98, 35));
        }
        if (container.m_6643_() >= 5) {
            this.m_38897_(new ConstraintInsertSlot(container, slotIndex, 116, 35));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceItem = sourceSlot.m_7993_();
        ItemStack sourceItemCopy = sourceItem.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceItem, 36, 36 + this.container.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 36 + this.container.m_6643_()) {
            if (!this.m_38903_(sourceItem, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(player, sourceItem);
        return sourceItemCopy;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

