/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SetCheckboxC2SPacket;
import me.jddev0.ep.networking.packet.SetFluidTankFilterC2SPacket;
import me.jddev0.ep.screen.FluidTankMenu;
import me.jddev0.ep.screen.base.EnergizedPowerBaseContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

@OnlyIn(value=Dist.CLIENT)
public class FluidTankScreen
extends EnergizedPowerBaseContainerScreen<FluidTankMenu> {
    private final ResourceLocation TEXTURE = EPAPI.id("textures/gui/container/fluid_tank.png");

    public FluidTankScreen(FluidTankMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            boolean clicked = false;
            if (this.m_6774_(158, 16, 11, 11, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetCheckboxC2SPacket(((FluidTankMenu)this.f_97732_).getBlockEntity().m_58899_(), 0, !((FluidTankMenu)this.f_97732_).isIgnoreNBT()));
                clicked = true;
            }
            if (this.m_6774_(151, 34, 18, 18, mouseX, mouseY)) {
                IFluidHandlerItem fluidStorage;
                FluidStack fluidFilter = FluidStack.EMPTY;
                ItemStack carriedItemStack = ((FluidTankMenu)this.f_97732_).m_142621_();
                LazyOptional fluidStorageLazyOptional = carriedItemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
                if (fluidStorageLazyOptional.isPresent() && (fluidStorage = (IFluidHandlerItem)fluidStorageLazyOptional.orElse(null)) != null && fluidStorage.getTanks() > 0) {
                    fluidFilter = fluidStorage.getFluidInTank(0);
                }
                ModMessages.sendToServer(new SetFluidTankFilterC2SPacket(((FluidTankMenu)this.f_97732_).getBlockEntity().m_58899_(), fluidFilter));
                clicked = true;
            }
            if (clicked) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(this.TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                this.renderFluidMeterContent(guiGraphics, ((FluidTankMenu)this.f_97732_).getFluid(0), ((FluidTankMenu)this.f_97732_).getTankCapacity(0), x + 80, y + 17, 16, 52);
            } else {
                this.renderFluidMeterContent(guiGraphics, ((FluidTankMenu)this.f_97732_).getFluid(1), -1, x + 152, y + 35, 16, 16);
            }
            this.renderFluidMeterOverlay(guiGraphics, x, y, i);
        }
        this.renderCheckboxes(guiGraphics, x, y, mouseX, mouseY);
    }

    private void renderFluidMeterOverlay(GuiGraphics guiGraphics, int x, int y, int tank) {
        if (tank == 0) {
            guiGraphics.m_280218_(this.TEXTURE, x + 80, y + 17, 176, 0, 16, 52);
        } else if (tank == 1) {
            guiGraphics.m_280218_(this.TEXTURE, x + 152, y + 35, 176, 64, 16, 16);
        }
    }

    private void renderCheckboxes(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (((FluidTankMenu)this.f_97732_).isIgnoreNBT()) {
            guiGraphics.m_280218_(this.TEXTURE, x + 158, y + 16, 176, 53, 11, 11);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components;
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.m_6774_(80, 17, 16, 52, mouseX, mouseY)) {
            components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((FluidTankMenu)this.f_97732_).getFluid(0).isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((FluidTankMenu)this.f_97732_).getFluid(0).getAmount();
            MutableComponent tooltipComponent = Component.m_237110_((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((FluidTankMenu)this.f_97732_).getTankCapacity(0))});
            if (!fluidEmpty) {
                tooltipComponent = Component.m_237115_((String)((FluidTankMenu)this.f_97732_).getFluid(0).getTranslationKey()).m_130946_(" ").m_7220_((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.m_6774_(158, 16, 11, 11, mouseX, mouseY)) {
            components = new ArrayList(2);
            components.add(Component.m_237115_((String)"tooltip.energizedpower.fluid_tanks.cbx.ignore_nbt"));
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.m_6774_(151, 34, 18, 18, mouseX, mouseY)) {
            components = new ArrayList(2);
            FluidStack fluidFilter = ((FluidTankMenu)this.f_97732_).getFluid(1);
            if (fluidFilter.isEmpty()) {
                components.add(Component.m_237115_((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.no_filter_set"));
            } else {
                components.add(Component.m_237110_((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.filter_set", (Object[])new Object[]{Component.m_237115_((String)fluidFilter.getTranslationKey())}));
            }
            components.add(Component.m_237119_());
            components.add(Component.m_237115_((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.txt.1").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            components.add(Component.m_237115_((String)"tooltip.energizedpower.fluid_tanks.fluid_filter.txt.2").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

