/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.block.entity.FluidTankBlockEntity;
import me.jddev0.ep.screen.EPMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;

public class FluidTankMenu
extends AbstractContainerMenu {
    private final FluidTankBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public static MenuType<FluidTankMenu> getMenuTypeFromTier(FluidTankBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case FluidTankBlock.Tier.SMALL -> (MenuType)EPMenuTypes.FLUID_TANK_SMALL.get();
            case FluidTankBlock.Tier.MEDIUM -> (MenuType)EPMenuTypes.FLUID_TANK_MEDIUM.get();
            case FluidTankBlock.Tier.LARGE -> (MenuType)EPMenuTypes.FLUID_TANK_LARGE.get();
        };
    }

    public FluidTankMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.f_35978_.m_9236_().m_7702_(buffer.m_130135_()), (ContainerData)new SimpleContainerData(1));
    }

    public FluidTankMenu(int id, Inventory inv, BlockEntity blockEntity, ContainerData data) {
        super(FluidTankMenu.getMenuTypeFromTier(((FluidTankBlockEntity)blockEntity).getTier()), id);
        FluidTankMenu.m_38886_((ContainerData)data, (int)1);
        this.blockEntity = (FluidTankBlockEntity)blockEntity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.m_38884_(this.data);
    }

    public FluidTankBlock.Tier getTier() {
        return this.blockEntity.getTier();
    }

    public FluidStack getFluid(int tank) {
        return this.blockEntity.getFluid(tank);
    }

    public int getTankCapacity(int tank) {
        return this.blockEntity.getTankCapacity(tank);
    }

    public boolean isIgnoreNBT() {
        return this.data.m_6413_(0) != 0;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return FluidTankMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)FluidTankBlock.getBlockFromTier(this.getTier()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

