/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.screen.FluidFillerMenu;
import me.jddev0.ep.screen.base.ConfigurableUpgradableEnergyStorageContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FluidFillerScreen
extends ConfigurableUpgradableEnergyStorageContainerScreen<FluidFillerMenu> {
    public FluidFillerScreen(FluidFillerMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, EPAPI.id("textures/gui/container/fluid_filler.png"), EPAPI.id("textures/gui/container/upgrade_view/1_energy_efficiency_1_energy_capacity.png"));
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderFluidMeterContent(guiGraphics, ((FluidFillerMenu)this.f_97732_).getFluid(), ((FluidFillerMenu)this.f_97732_).getTankCapacity(), x + 152, y + 17, 16, 52);
        this.renderFluidMeterOverlay(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280218_(this.TEXTURE, x + 152, y + 17, 176, 53, 16, 52);
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        if (this.m_6774_(152, 17, 16, 52, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((FluidFillerMenu)this.f_97732_).getFluid().isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((FluidFillerMenu)this.f_97732_).getFluid().getAmount();
            MutableComponent tooltipComponent = Component.m_237110_((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((FluidFillerMenu)this.f_97732_).getTankCapacity())});
            if (!fluidEmpty) {
                tooltipComponent = Component.m_237115_((String)((FluidFillerMenu)this.f_97732_).getFluid().getTranslationKey()).m_130946_(" ").m_7220_((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.m_280677_(this.f_96547_, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

