/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.AlloyFurnaceBlockEntity;
import me.jddev0.ep.screen.EPMenuTypes;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;

public class AlloyFurnaceMenu
extends AbstractContainerMenu {
    private final AlloyFurnaceBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;

    public AlloyFurnaceMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, inv.f_35978_.m_9236_().m_7702_(buffer.m_130135_()), (ContainerData)new SimpleContainerData(8));
    }

    public AlloyFurnaceMenu(int id, Inventory inv, BlockEntity blockEntity, ContainerData data) {
        super((MenuType)EPMenuTypes.ALLOY_FURNACE_MENU.get(), id);
        AlloyFurnaceMenu.m_38886_((ContainerData)data, (int)8);
        this.blockEntity = (AlloyFurnaceBlockEntity)blockEntity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.m_38884_(this.data);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 0, 14, 20));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 1, 35, 17));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 2, 56, 20));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 3, 35, 53));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 4, 116, 35));
            this.m_38897_((Slot)new SlotItemHandler(itemHandler, 5, 143, 35));
        });
    }

    public boolean isCraftingActive() {
        return ByteUtils.from2ByteChunks((short)this.data.m_6413_(0), (short)this.data.m_6413_(1)) > 0;
    }

    public int getScaledProgressArrowSize() {
        int progress = ByteUtils.from2ByteChunks((short)this.data.m_6413_(0), (short)this.data.m_6413_(1));
        int maxProgress = ByteUtils.from2ByteChunks((short)this.data.m_6413_(2), (short)this.data.m_6413_(3));
        int progressArrowSize = 24;
        return maxProgress == 0 || progress == 0 ? 0 : progress * progressArrowSize / maxProgress;
    }

    public boolean isBurningFuel() {
        return ByteUtils.from2ByteChunks((short)this.data.m_6413_(4), (short)this.data.m_6413_(5)) > 0;
    }

    public int getScaledProgressFlameSize() {
        int progress = ByteUtils.from2ByteChunks((short)this.data.m_6413_(4), (short)this.data.m_6413_(5));
        int maxProgress = ByteUtils.from2ByteChunks((short)this.data.m_6413_(6), (short)this.data.m_6413_(7));
        int progressFlameSize = 14;
        return maxProgress == 0 || progress == 0 ? 0 : progress * progressFlameSize / maxProgress;
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceItem = sourceSlot.m_7993_();
        ItemStack sourceItemCopy = sourceItem.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceItem, 36, 40, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 42) {
            if (!this.m_38903_(sourceItem, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            throw new IllegalArgumentException("Invalid slot index");
        }
        if (sourceItem.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(player, sourceItem);
        return sourceItemCopy;
    }

    public boolean m_6875_(Player player) {
        return AlloyFurnaceMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)EPBlocks.ALLOY_FURNACE.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

