/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.item.EPItems;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SawmillRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final ItemStack secondaryOutput;
    private final Ingredient input;

    public SawmillRecipe(ResourceLocation id, ItemStack output, Ingredient input, int sawdustAmount) {
        this(id, output, new ItemStack((ItemLike)EPItems.SAWDUST.get(), sawdustAmount), input);
    }

    public SawmillRecipe(ResourceLocation id, ItemStack output, ItemStack secondaryOutput, Ingredient input) {
        this.id = id;
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.input = input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public boolean m_5818_(Container container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        return this.input.test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_182647_((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)EPBlocks.SAWMILL_ITEM.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<SawmillRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("sawmill");

        private Serializer() {
        }

        public SawmillRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            if (json.has("secondaryOutput")) {
                ItemStack secondaryOutput = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"secondaryOutput"));
                return new SawmillRecipe(recipeID, output, secondaryOutput, input);
            }
            int sawdustAmount = json.get("sawdustAmount").getAsInt();
            return new SawmillRecipe(recipeID, output, input, sawdustAmount);
        }

        public SawmillRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            ItemStack secondaryOutput = buffer.m_130267_();
            return new SawmillRecipe(recipeID, output, secondaryOutput, input);
        }

        public void toNetwork(FriendlyByteBuf buffer, SawmillRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.writeItemStack(recipe.output, false);
            buffer.writeItemStack(recipe.secondaryOutput, false);
        }
    }

    public static final class Type
    implements RecipeType<SawmillRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "sawmill";

        private Type() {
        }
    }
}

