/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PulverizerRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final OutputItemStackWithPercentages output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final Ingredient input;

    public PulverizerRecipe(ResourceLocation id, OutputItemStackWithPercentages output, OutputItemStackWithPercentages secondaryOutput, Ingredient input) {
        this.id = id;
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.input = input;
    }

    public OutputItemStackWithPercentages getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack[] getMaxOutputCounts(boolean advanced) {
        ItemStack[] generatedOutputs = new ItemStack[]{this.output.output.m_255036_(advanced ? this.output.percentagesAdvanced.length : this.output.percentages.length), this.secondaryOutput.output.m_255036_(advanced ? this.secondaryOutput.percentagesAdvanced.length : this.secondaryOutput.percentages.length)};
        return generatedOutputs;
    }

    public ItemStack[] generateOutputs(RandomSource randomSource, boolean advanced) {
        ItemStack[] generatedOutputs = new ItemStack[2];
        for (int i = 0; i < 2; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = i == 0 ? this.output : this.secondaryOutput;
            for (double percentage : advanced ? output.percentagesAdvanced : output.percentages) {
                if (!(randomSource.m_188500_() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output.m_255036_(count);
        }
        return generatedOutputs;
    }

    public boolean m_5818_(Container container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        return this.input.test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_182647_((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)EPBlocks.PULVERIZER_ITEM.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public record OutputItemStackWithPercentages(ItemStack output, double[] percentages, double[] percentagesAdvanced) {
        public OutputItemStackWithPercentages(ItemStack output, double percentage, double percentageAdvanced) {
            this(output, new double[]{percentage}, new double[]{percentageAdvanced});
        }

        public OutputItemStackWithPercentages(ItemStack output) {
            this(output, 1.0, 1.0);
        }
    }

    public static final class Serializer
    implements RecipeSerializer<PulverizerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("pulverizer");

        private Serializer() {
        }

        public PulverizerRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[2];
            for (int i = 0; i < 2; ++i) {
                JsonObject outputJson = json.getAsJsonObject(i == 0 ? "output" : "secondaryOutput");
                ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)outputJson, (String)"output"));
                JsonArray percentagesJson = GsonHelper.m_13933_((JsonObject)outputJson, (String)"percentages");
                double[] percentages = new double[percentagesJson.size()];
                boolean minimumAtLeastOneFlag = false;
                for (int j = 0; j < percentagesJson.size(); ++j) {
                    double value = percentagesJson.get(j).getAsDouble();
                    minimumAtLeastOneFlag |= (int)value >= 1;
                    percentages[j] = value;
                }
                if (i == 0 && !minimumAtLeastOneFlag) {
                    throw new JsonSyntaxException("The primary output must have a minimum count of at least 1 (At least one percentage value must be >= 1.0)");
                }
                JsonArray percentagesAdvancedJson = outputJson.has("percentagesAdvanced") ? GsonHelper.m_13933_((JsonObject)outputJson, (String)"percentagesAdvanced") : percentagesJson;
                double[] percentagesAdvanced = new double[percentagesAdvancedJson.size()];
                minimumAtLeastOneFlag = false;
                for (int j = 0; j < percentagesAdvancedJson.size(); ++j) {
                    double value = percentagesAdvancedJson.get(j).getAsDouble();
                    minimumAtLeastOneFlag |= (int)value >= 1;
                    percentagesAdvanced[j] = value;
                }
                if (i == 0 && !minimumAtLeastOneFlag) {
                    throw new JsonSyntaxException("The primary output must have a minimum count of at least 1 (At least one percentage value must be >= 1.0)");
                }
                outputs[i] = new OutputItemStackWithPercentages(output, percentages, percentagesAdvanced);
                if (json.has("secondaryOutput")) continue;
                outputs[1] = new OutputItemStackWithPercentages(ItemStack.f_41583_, new double[0], new double[0]);
                break;
            }
            return new PulverizerRecipe(recipeID, outputs[0], outputs[1], input);
        }

        public PulverizerRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[2];
            for (int i = 0; i < 2; ++i) {
                ItemStack output = buffer.m_130267_();
                int percentageCount = buffer.readInt();
                double[] percentages = new double[percentageCount];
                for (int j = 0; j < percentageCount; ++j) {
                    percentages[j] = buffer.readDouble();
                }
                int percentageAdvancedCount = buffer.readInt();
                double[] percentagesAdvanced = new double[percentageAdvancedCount];
                for (int j = 0; j < percentageAdvancedCount; ++j) {
                    percentagesAdvanced[j] = buffer.readDouble();
                }
                outputs[i] = new OutputItemStackWithPercentages(output, percentages, percentagesAdvanced);
            }
            return new PulverizerRecipe(recipeID, outputs[0], outputs[1], input);
        }

        public void toNetwork(FriendlyByteBuf buffer, PulverizerRecipe recipe) {
            recipe.input.m_43923_(buffer);
            for (int i = 0; i < 2; ++i) {
                OutputItemStackWithPercentages output = i == 0 ? recipe.output : recipe.secondaryOutput;
                buffer.writeItemStack(output.output, false);
                buffer.writeInt(output.percentages.length);
                for (double percentage : output.percentages) {
                    buffer.writeDouble(percentage);
                }
                buffer.writeInt(output.percentagesAdvanced.length);
                for (double percentage : output.percentagesAdvanced) {
                    buffer.writeDouble(percentage);
                }
            }
        }
    }

    public static final class Type
    implements RecipeType<PulverizerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "pulverizer";

        private Type() {
        }
    }
}

