/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonObject;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PressMoldMakerRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final int clayCount;

    public PressMoldMakerRecipe(ResourceLocation id, ItemStack output, int clayCount) {
        this.id = id;
        this.output = output;
        this.clayCount = clayCount;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getClayCount() {
        return this.clayCount;
    }

    public boolean m_5818_(Container container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        ItemStack item = container.m_8020_(0);
        return item.m_150930_(Items.f_42461_) && item.m_41613_() >= this.clayCount;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)EPBlocks.PRESS_MOLD_MAKER_ITEM.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<PressMoldMakerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("press_mold_maker");

        private Serializer() {
        }

        public PressMoldMakerRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            int clayCount = GsonHelper.m_13927_((JsonObject)json, (String)"clayCount");
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            return new PressMoldMakerRecipe(recipeID, output, clayCount);
        }

        public PressMoldMakerRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            int clayCount = buffer.readInt();
            ItemStack output = buffer.m_130267_();
            return new PressMoldMakerRecipe(recipeID, output, clayCount);
        }

        public void toNetwork(FriendlyByteBuf buffer, PressMoldMakerRecipe recipe) {
            buffer.writeInt(recipe.clayCount);
            buffer.writeItemStack(recipe.output, false);
        }
    }

    public static final class Type
    implements RecipeType<PressMoldMakerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "press_mold_maker";

        private Type() {
        }
    }
}

