/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PlantGrowthChamberRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final OutputItemStackWithPercentages[] outputs;
    private final Ingredient input;
    private final int ticks;

    public PlantGrowthChamberRecipe(ResourceLocation id, OutputItemStackWithPercentages[] outputs, Ingredient input, int ticks) {
        this.id = id;
        this.outputs = outputs;
        this.input = input;
        this.ticks = ticks;
    }

    public OutputItemStackWithPercentages[] getOutputs() {
        return this.outputs;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getTicks() {
        return this.ticks;
    }

    public ItemStack[] getMaxOutputCounts() {
        ItemStack[] generatedOutputs = new ItemStack[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            OutputItemStackWithPercentages output = this.outputs[i];
            generatedOutputs[i] = output.output().m_255036_(output.percentages().length);
        }
        return generatedOutputs;
    }

    public ItemStack[] generateOutputs(RandomSource randomSource) {
        ItemStack[] generatedOutputs = new ItemStack[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = this.outputs[i];
            for (double percentage : output.percentages()) {
                if (!(randomSource.m_188500_() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output().m_255036_(count);
        }
        return generatedOutputs;
    }

    public boolean m_5818_(Container container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        return this.input.test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_182647_((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)EPBlocks.PLANT_GROWTH_CHAMBER_ITEM.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<PlantGrowthChamberRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("plant_growth_chamber");

        private Serializer() {
        }

        public PlantGrowthChamberRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            int ticks = GsonHelper.m_13927_((JsonObject)json, (String)"ticks");
            JsonArray outputsJson = GsonHelper.m_13933_((JsonObject)json, (String)"outputs");
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[outputsJson.size()];
            for (int i = 0; i < outputsJson.size(); ++i) {
                outputs[i] = OutputItemStackWithPercentages.fromJson(outputsJson.get(i).getAsJsonObject());
            }
            return new PlantGrowthChamberRecipe(recipeID, outputs, input, ticks);
        }

        public PlantGrowthChamberRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int ticks = buffer.readInt();
            int outputCount = buffer.readInt();
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[outputCount];
            for (int i = 0; i < outputCount; ++i) {
                outputs[i] = OutputItemStackWithPercentages.fromNetwork(buffer);
            }
            return new PlantGrowthChamberRecipe(recipeID, outputs, input, ticks);
        }

        public void toNetwork(FriendlyByteBuf buffer, PlantGrowthChamberRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.writeInt(recipe.ticks);
            buffer.writeInt(recipe.outputs.length);
            for (OutputItemStackWithPercentages output : recipe.outputs) {
                output.toNetwork(buffer);
            }
        }
    }

    public static final class Type
    implements RecipeType<PlantGrowthChamberRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "plant_growth_chamber";

        private Type() {
        }
    }
}

