/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;

public record OutputItemStackWithPercentages(ItemStack output, double[] percentages) {
    public static final OutputItemStackWithPercentages EMPTY = new OutputItemStackWithPercentages(ItemStack.f_41583_, new double[0]);

    public OutputItemStackWithPercentages(ItemStack output, double percentage) {
        this(output, new double[]{percentage});
    }

    public OutputItemStackWithPercentages(ItemStack output) {
        this(output, 1.0);
    }

    public boolean isEmpty() {
        return this.output.m_41619_() || this.percentages.length == 0;
    }

    public static OutputItemStackWithPercentages fromJson(JsonObject json) {
        ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
        JsonArray percentagesJson = GsonHelper.m_13933_((JsonObject)json, (String)"percentages");
        double[] percentages = new double[percentagesJson.size()];
        for (int j = 0; j < percentagesJson.size(); ++j) {
            double value;
            percentages[j] = value = percentagesJson.get(j).getAsDouble();
        }
        return new OutputItemStackWithPercentages(output, percentages);
    }

    public static OutputItemStackWithPercentages fromNetwork(FriendlyByteBuf buffer) {
        int percentageCount = buffer.readInt();
        if (percentageCount <= 0) {
            return EMPTY;
        }
        double[] percentages = new double[percentageCount];
        for (int j = 0; j < percentageCount; ++j) {
            percentages[j] = buffer.readDouble();
        }
        ItemStack output = buffer.m_130267_();
        return new OutputItemStackWithPercentages(output, percentages);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        if (this.isEmpty()) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(this.percentages.length);
            for (double percentage : this.percentages) {
                buffer.writeDouble(percentage);
            }
            buffer.writeItemStack(this.output, false);
        }
    }
}

