/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MetalPressRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final ItemStack pressMold;
    private final Ingredient input;
    private final int inputCount;

    public MetalPressRecipe(ResourceLocation id, ItemStack output, ItemStack pressMold, Ingredient input) {
        this(id, output, pressMold, input, 1);
    }

    public MetalPressRecipe(ResourceLocation id, ItemStack output, ItemStack pressMold, Ingredient input, int inputCount) {
        this.id = id;
        this.output = output;
        this.pressMold = pressMold;
        this.input = input;
        this.inputCount = inputCount;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack getPressMold() {
        return this.pressMold;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public boolean m_5818_(Container container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        return this.input.test(container.m_8020_(0)) && container.m_8020_(0).m_41613_() >= this.inputCount && ItemStack.m_41656_((ItemStack)container.m_8020_(1), (ItemStack)this.pressMold);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)EPBlocks.METAL_PRESS_ITEM.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<MetalPressRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("metal_press");

        private Serializer() {
        }

        public MetalPressRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            ItemStack pressMold = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"pressMold"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            if (json.has("inputCount")) {
                int inputCount = GsonHelper.m_13927_((JsonObject)json, (String)"inputCount");
                return new MetalPressRecipe(recipeID, output, pressMold, input, inputCount);
            }
            return new MetalPressRecipe(recipeID, output, pressMold, input);
        }

        public MetalPressRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int inputCount = buffer.readInt();
            ItemStack pressMold = buffer.m_130267_();
            ItemStack output = buffer.m_130267_();
            return new MetalPressRecipe(recipeID, output, pressMold, input, inputCount);
        }

        public void toNetwork(FriendlyByteBuf buffer, MetalPressRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.writeInt(recipe.inputCount);
            buffer.writeItemStack(recipe.pressMold, false);
            buffer.writeItemStack(recipe.output, false);
        }
    }

    public static final class Type
    implements RecipeType<MetalPressRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "metal_press";

        private Type() {
        }
    }
}

