/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;

public record IngredientWithCount(Ingredient input, int count) {
    public static final IngredientWithCount EMPTY = new IngredientWithCount(Ingredient.f_43901_, 0);

    public IngredientWithCount(Ingredient input) {
        this(input, 1);
    }

    public boolean isEmpty() {
        return this.input.m_43947_() || this.count <= 0;
    }

    public static IngredientWithCount fromJson(JsonObject json) {
        Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
        int count = json.has("count") ? GsonHelper.m_13927_((JsonObject)json, (String)"count") : 1;
        return new IngredientWithCount(input, count);
    }

    public static IngredientWithCount fromNetwork(FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        if (count <= 0) {
            return EMPTY;
        }
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        return new IngredientWithCount(input, count);
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        if (this.isEmpty()) {
            buffer.writeInt(0);
        } else {
            buffer.writeInt(this.count);
            this.input.m_43923_(buffer);
        }
    }
}

