/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonObject;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FiltrationPlantRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final OutputItemStackWithPercentages output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final ResourceLocation icon;

    public FiltrationPlantRecipe(ResourceLocation id, OutputItemStackWithPercentages output, OutputItemStackWithPercentages secondaryOutput, ResourceLocation icon) {
        this.id = id;
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.icon = icon;
    }

    public OutputItemStackWithPercentages getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public ItemStack[] getMaxOutputCounts() {
        ItemStack[] generatedOutputs = new ItemStack[]{this.output.output().m_255036_(this.output.percentages().length), this.secondaryOutput.output().m_255036_(this.secondaryOutput.percentages().length)};
        return generatedOutputs;
    }

    public ItemStack[] generateOutputs(RandomSource randomSource) {
        ItemStack[] generatedOutputs = new ItemStack[2];
        for (int i = 0; i < 2; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = i == 0 ? this.output : this.secondaryOutput;
            for (double percentage : output.percentages()) {
                if (!(randomSource.m_188500_() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output().m_255036_(count);
        }
        return generatedOutputs;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)EPBlocks.FILTRATION_PLANT.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<FiltrationPlantRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("filtration_plant");

        private Serializer() {
        }

        public FiltrationPlantRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[]{OutputItemStackWithPercentages.fromJson(json.get("output").getAsJsonObject()), json.has("secondaryOutput") ? OutputItemStackWithPercentages.fromJson(json.get("secondaryOutput").getAsJsonObject()) : OutputItemStackWithPercentages.EMPTY};
            ResourceLocation icon = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)json, (String)"icon"));
            return new FiltrationPlantRecipe(recipeID, outputs[0], outputs[1], icon);
        }

        public FiltrationPlantRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[2];
            for (int i = 0; i < 2; ++i) {
                outputs[i] = OutputItemStackWithPercentages.fromNetwork(buffer);
            }
            ResourceLocation icon = buffer.m_130281_();
            return new FiltrationPlantRecipe(recipeID, outputs[0], outputs[1], icon);
        }

        public void toNetwork(FriendlyByteBuf buffer, FiltrationPlantRecipe recipe) {
            for (int i = 0; i < 2; ++i) {
                OutputItemStackWithPercentages output = i == 0 ? recipe.output : recipe.secondaryOutput;
                output.toNetwork(buffer);
            }
            buffer.m_130085_(recipe.icon);
        }
    }

    public static final class Type
    implements RecipeType<FiltrationPlantRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "filtration_plant";

        private Type() {
        }
    }
}

