/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CrystalGrowthChamberRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final OutputItemStackWithPercentages output;
    private final Ingredient input;
    private final int inputCount;
    private final int ticks;

    public CrystalGrowthChamberRecipe(ResourceLocation id, OutputItemStackWithPercentages output, Ingredient input, int inputCount, int ticks) {
        this.id = id;
        this.output = output;
        this.input = input;
        this.inputCount = inputCount;
        this.ticks = ticks;
    }

    public OutputItemStackWithPercentages getOutput() {
        return this.output;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public int getTicks() {
        return this.ticks;
    }

    public ItemStack getMaxOutputCount() {
        return this.output.output().m_255036_(this.output.percentages().length);
    }

    public ItemStack generateOutput(RandomSource randomSource) {
        int count = 0;
        for (double percentage : this.output.percentages()) {
            if (!(randomSource.m_188500_() <= percentage)) continue;
            ++count;
        }
        return this.output.output().m_255036_(count);
    }

    public boolean m_5818_(Container container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        return this.input.test(container.m_8020_(0)) && container.m_8020_(0).m_41613_() >= this.inputCount;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)EPBlocks.CRYSTAL_GROWTH_CHAMBER_ITEM.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<CrystalGrowthChamberRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("crystal_growth_chamber");

        private Serializer() {
        }

        public CrystalGrowthChamberRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            int inputCount = json.has("inputCount") ? GsonHelper.m_13927_((JsonObject)json, (String)"inputCount") : 1;
            int ticks = GsonHelper.m_13927_((JsonObject)json, (String)"ticks");
            OutputItemStackWithPercentages output = OutputItemStackWithPercentages.fromJson(json.get("output").getAsJsonObject());
            return new CrystalGrowthChamberRecipe(recipeID, output, input, inputCount, ticks);
        }

        public CrystalGrowthChamberRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int inputCount = buffer.readInt();
            int ticks = buffer.readInt();
            OutputItemStackWithPercentages output = OutputItemStackWithPercentages.fromNetwork(buffer);
            return new CrystalGrowthChamberRecipe(recipeId, output, input, inputCount, ticks);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrystalGrowthChamberRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.writeInt(recipe.inputCount);
            buffer.writeInt(recipe.ticks);
            recipe.output.toNetwork(buffer);
        }
    }

    public static final class Type
    implements RecipeType<CrystalGrowthChamberRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "crystal_growth_chamber";

        private Type() {
        }
    }
}

