/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.IngredientWithCount;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AssemblingMachineRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final IngredientWithCount[] inputs;

    public AssemblingMachineRecipe(ResourceLocation id, ItemStack output, IngredientWithCount[] inputs) {
        this.id = id;
        this.output = output;
        this.inputs = inputs;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public IngredientWithCount[] getInputs() {
        return this.inputs;
    }

    public boolean m_5818_(Container container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        boolean[] usedIndices = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            usedIndices[i] = container.m_8020_(i).m_41619_();
        }
        int len = Math.min(this.inputs.length, 4);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = this.inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 4; ++j) {
                if (usedIndices[j]) continue;
                ItemStack item = container.m_8020_(j);
                if (indexMinCount != -1 && item.m_41613_() >= minCount || !input.input().test(item) || item.m_41613_() < input.count()) continue;
                indexMinCount = j;
                minCount = item.m_41613_();
            }
            if (indexMinCount == -1) {
                return false;
            }
            usedIndices[indexMinCount] = true;
        }
        for (boolean usedIndex : usedIndices) {
            if (usedIndex) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)EPBlocks.ASSEMBLING_MACHINE_ITEM.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<AssemblingMachineRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("assembling_machine");

        private Serializer() {
        }

        public AssemblingMachineRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            JsonArray inputsJson = GsonHelper.m_13933_((JsonObject)json, (String)"inputs");
            IngredientWithCount[] inputs = new IngredientWithCount[inputsJson.size()];
            for (int i = 0; i < inputsJson.size(); ++i) {
                inputs[i] = IngredientWithCount.fromJson(inputsJson.get(i).getAsJsonObject());
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            return new AssemblingMachineRecipe(recipeID, output, inputs);
        }

        public AssemblingMachineRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            int len = buffer.readInt();
            IngredientWithCount[] inputs = new IngredientWithCount[len];
            for (int i = 0; i < len; ++i) {
                inputs[i] = IngredientWithCount.fromNetwork(buffer);
            }
            ItemStack output = buffer.m_130267_();
            return new AssemblingMachineRecipe(recipeID, output, inputs);
        }

        public void toNetwork(FriendlyByteBuf buffer, AssemblingMachineRecipe recipe) {
            buffer.writeInt(recipe.inputs.length);
            for (int i = 0; i < recipe.inputs.length; ++i) {
                recipe.inputs[i].toNetwork(buffer);
            }
            buffer.writeItemStack(recipe.output, false);
        }
    }

    public static final class Type
    implements RecipeType<AssemblingMachineRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "assembling_machine";

        private Type() {
        }
    }
}

