/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AlloyFurnaceRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final IngredientWithCount[] inputs;
    private final int ticks;

    public AlloyFurnaceRecipe(ResourceLocation id, ItemStack output, OutputItemStackWithPercentages secondaryOutput, IngredientWithCount[] inputs, int ticks) {
        this.id = id;
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.inputs = inputs;
        this.ticks = ticks;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public IngredientWithCount[] getInputs() {
        return this.inputs;
    }

    public int getTicks() {
        return this.ticks;
    }

    public ItemStack[] getMaxOutputCounts() {
        ItemStack[] generatedOutputs = new ItemStack[]{this.output.m_255036_(this.output.m_41613_()), this.secondaryOutput.output().m_255036_(this.secondaryOutput.percentages().length)};
        return generatedOutputs;
    }

    public ItemStack[] generateOutputs(RandomSource randomSource) {
        ItemStack[] generatedOutputs = new ItemStack[2];
        generatedOutputs[0] = this.output.m_255036_(this.output.m_41613_());
        int count = 0;
        for (double percentage : this.secondaryOutput.percentages()) {
            if (!(randomSource.m_188500_() <= percentage)) continue;
            ++count;
        }
        generatedOutputs[1] = this.secondaryOutput.output().m_255036_(count);
        return generatedOutputs;
    }

    public boolean m_5818_(Container container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        boolean[] usedIndices = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            usedIndices[i] = container.m_8020_(i).m_41619_();
        }
        int len = Math.min(this.inputs.length, 3);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = this.inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 3; ++j) {
                if (usedIndices[j]) continue;
                ItemStack item = container.m_8020_(j);
                if (indexMinCount != -1 && item.m_41613_() >= minCount || !input.input().test(item) || item.m_41613_() < input.count()) continue;
                indexMinCount = j;
                minCount = item.m_41613_();
            }
            if (indexMinCount == -1) {
                return false;
            }
            usedIndices[indexMinCount] = true;
        }
        for (boolean usedIndex : usedIndices) {
            if (usedIndex) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registries) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registries) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)EPBlocks.ALLOY_FURNACE_ITEM.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<AlloyFurnaceRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("alloy_furnace");

        private Serializer() {
        }

        public AlloyFurnaceRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            JsonArray inputsJson = GsonHelper.m_13933_((JsonObject)json, (String)"inputs");
            IngredientWithCount[] inputs = new IngredientWithCount[inputsJson.size()];
            for (int i = 0; i < inputsJson.size(); ++i) {
                inputs[i] = IngredientWithCount.fromJson(inputsJson.get(i).getAsJsonObject());
            }
            int ticks = GsonHelper.m_13927_((JsonObject)json, (String)"ticks");
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            OutputItemStackWithPercentages secondaryOutput = json.has("secondaryOutput") ? OutputItemStackWithPercentages.fromJson(json.get("secondaryOutput").getAsJsonObject()) : OutputItemStackWithPercentages.EMPTY;
            return new AlloyFurnaceRecipe(recipeID, output, secondaryOutput, inputs, ticks);
        }

        public AlloyFurnaceRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buffer) {
            int len = buffer.readInt();
            IngredientWithCount[] inputs = new IngredientWithCount[len];
            for (int i = 0; i < len; ++i) {
                inputs[i] = IngredientWithCount.fromNetwork(buffer);
            }
            int ticks = buffer.readInt();
            ItemStack output = buffer.m_130267_();
            OutputItemStackWithPercentages secondaryOutput = OutputItemStackWithPercentages.fromNetwork(buffer);
            return new AlloyFurnaceRecipe(recipeID, output, secondaryOutput, inputs, ticks);
        }

        public void toNetwork(FriendlyByteBuf buffer, AlloyFurnaceRecipe recipe) {
            buffer.writeInt(recipe.inputs.length);
            for (int i = 0; i < recipe.inputs.length; ++i) {
                recipe.inputs[i].toNetwork(buffer);
            }
            buffer.writeInt(recipe.ticks);
            buffer.writeItemStack(recipe.output, false);
            recipe.secondaryOutput.toNetwork(buffer);
        }
    }

    public static final class Type
    implements RecipeType<AlloyFurnaceRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "alloy_furnace";

        private Type() {
        }
    }
}

