/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import java.util.function.Supplier;
import me.jddev0.ep.recipe.CurrentRecipePacketUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class SyncCurrentRecipeS2CPacket<R extends Recipe<?>> {
    private final BlockPos pos;
    private final RecipeSerializer<R> recipeSerializer;
    private final R currentRecipe;

    public SyncCurrentRecipeS2CPacket(BlockPos pos, RecipeSerializer<R> recipeSerializerId, @Nullable R currentRecipe) {
        this.pos = pos;
        this.recipeSerializer = recipeSerializerId;
        this.currentRecipe = currentRecipe;
    }

    public SyncCurrentRecipeS2CPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        ResourceLocation recipeSerializerId = buffer.m_130281_();
        this.recipeSerializer = (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(recipeSerializerId);
        if (this.recipeSerializer == null) {
            throw new IllegalArgumentException("Recipe Serializer \"" + recipeSerializerId + "\" does not exist!");
        }
        this.currentRecipe = buffer.readBoolean() ? this.recipeSerializer.m_8005_(buffer.m_130281_(), buffer) : null;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        ResourceLocation recipeSerializerId = ForgeRegistries.RECIPE_SERIALIZERS.getKey(this.recipeSerializer);
        if (recipeSerializerId == null) {
            throw new IllegalArgumentException("The recipe serializer \"" + this.recipeSerializer.getClass().getCanonicalName() + "\" is not registered!");
        }
        buffer.m_130085_(recipeSerializerId);
        if (this.currentRecipe == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130085_(this.currentRecipe.m_6423_());
            this.recipeSerializer.m_6178_(buffer, this.currentRecipe);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (blockEntity instanceof CurrentRecipePacketUpdate) {
                CurrentRecipePacketUpdate currentRecipePacketUpdate = (CurrentRecipePacketUpdate)blockEntity;
                currentRecipePacketUpdate.setCurrentRecipe(this.currentRecipe);
            }
        });
        return true;
    }
}

