/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import java.util.function.Supplier;
import me.jddev0.ep.block.entity.WeatherControllerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SetWeatherFromWeatherControllerC2SPacket {
    private final BlockPos pos;
    private final int weatherType;

    public SetWeatherFromWeatherControllerC2SPacket(BlockPos pos, int weatherType) {
        this.pos = pos;
        this.weatherType = weatherType;
    }

    public SetWeatherFromWeatherControllerC2SPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.weatherType = buffer.readInt();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.weatherType);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Level level = context.getSender().m_9236_();
            if (!level.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (!(blockEntity instanceof WeatherControllerBlockEntity)) {
                return;
            }
            WeatherControllerBlockEntity weatherControllerBlockEntity = (WeatherControllerBlockEntity)blockEntity;
            if (!weatherControllerBlockEntity.hasEnoughEnergy()) {
                return;
            }
            if (weatherControllerBlockEntity.hasInfiniteWeatherChangedDuration()) {
                if (weatherControllerBlockEntity.getSelectedWeatherType() == this.weatherType) {
                    weatherControllerBlockEntity.setSelectedWeatherType(-1);
                    return;
                }
                weatherControllerBlockEntity.setSelectedWeatherType(this.weatherType);
            } else {
                weatherControllerBlockEntity.clearEnergy();
            }
            int duration = weatherControllerBlockEntity.getWeatherChangedDuration();
            switch (this.weatherType) {
                case 0: {
                    context.getSender().m_284548_().m_8606_(duration, 0, false, false);
                    break;
                }
                case 1: {
                    context.getSender().m_284548_().m_8606_(0, duration, true, false);
                    break;
                }
                case 2: {
                    context.getSender().m_284548_().m_8606_(0, duration, true, true);
                }
            }
        });
        return true;
    }
}

