/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.jddev0.ep.block.entity.AutoCrafterBlockEntity;
import me.jddev0.ep.screen.AutoCrafterMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SetAutoCrafterPatternInputSlotsC2SPacket {
    private final BlockPos pos;
    private final List<ItemStack> itemStacks;
    private final ResourceLocation recipeId;

    public SetAutoCrafterPatternInputSlotsC2SPacket(BlockPos pos, List<ItemStack> itemStacks, ResourceLocation recipeId) {
        this.pos = pos;
        this.itemStacks = new ArrayList<ItemStack>(itemStacks);
        while (this.itemStacks.size() < 9) {
            this.itemStacks.add(ItemStack.f_41583_);
        }
        this.recipeId = recipeId;
    }

    public SetAutoCrafterPatternInputSlotsC2SPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.itemStacks = new ArrayList<ItemStack>(9);
        for (int i = 0; i < 9; ++i) {
            this.itemStacks.add(buffer.m_130267_());
        }
        this.recipeId = buffer.m_130281_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        for (ItemStack itemStack : this.itemStacks) {
            buffer.writeItemStack(itemStack, false);
        }
        buffer.m_130085_(this.recipeId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Level level = context.getSender().m_9236_();
            if (!level.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (!(blockEntity instanceof AutoCrafterBlockEntity)) {
                return;
            }
            AutoCrafterBlockEntity autoCrafterBlockEntity = (AutoCrafterBlockEntity)blockEntity;
            AbstractContainerMenu menu = context.getSender().f_36096_;
            if (!(menu instanceof AutoCrafterMenu)) {
                return;
            }
            AutoCrafterMenu autoCrafterMenu = (AutoCrafterMenu)menu;
            for (int i = 0; i < this.itemStacks.size(); ++i) {
                autoCrafterMenu.getPatternSlots().m_6836_(i, this.itemStacks.get(i));
            }
            autoCrafterBlockEntity.setRecipeIdForSetRecipe(this.recipeId);
            autoCrafterBlockEntity.resetProgressAndMarkAsChanged();
        });
        return true;
    }
}

