/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import java.util.function.Supplier;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public class FluidSyncS2CPacket {
    private final int tank;
    private final FluidStack fluidStack;
    private final int capacity;
    private final BlockPos pos;

    public FluidSyncS2CPacket(int tank, FluidStack fluidStack, int capacity, BlockPos pos) {
        this.tank = tank;
        this.fluidStack = fluidStack;
        this.capacity = capacity;
        this.pos = pos;
    }

    public FluidSyncS2CPacket(FriendlyByteBuf buffer) {
        this.tank = buffer.readInt();
        this.fluidStack = buffer.readFluidStack();
        this.capacity = buffer.readInt();
        this.pos = buffer.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.tank);
        buffer.writeFluidStack(this.fluidStack);
        buffer.writeInt(this.capacity);
        buffer.m_130064_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (blockEntity instanceof FluidStoragePacketUpdate) {
                FluidStoragePacketUpdate fluidStorage = (FluidStoragePacketUpdate)blockEntity;
                fluidStorage.setTankCapacity(this.tank, this.capacity);
                fluidStorage.setFluid(this.tank, this.fluidStack);
            }
        });
        return true;
    }
}

