/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.loading;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.jddev0.ep.screen.EnergizedPowerBookScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class EnergizedPowerBookReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();

    public EnergizedPowerBookReloadListener() {
        super(new GsonBuilder().create(), "book_pages");
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        LinkedList<EnergizedPowerBookScreen.PageContent> pages = new LinkedList<EnergizedPowerBookScreen.PageContent>();
        List<Map.Entry> elementEntries = elements.entrySet().stream().sorted(Comparator.comparing(o -> ((ResourceLocation)o.getKey()).m_135815_())).toList();
        block2: for (Map.Entry elementEntry : elementEntries) {
            ResourceLocation pageId = (ResourceLocation)elementEntry.getKey();
            JsonElement element = (JsonElement)elementEntry.getValue();
            try {
                if (!element.isJsonObject()) {
                    LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': Element must be a JSON Object", pageId.m_135815_(), pageId.m_135827_()));
                    continue;
                }
                JsonObject object = element.getAsJsonObject();
                if (object.has("remove")) {
                    JsonElement pageToRemoveElement = object.get("remove");
                    if (!pageToRemoveElement.isJsonPrimitive() || !pageToRemoveElement.getAsJsonPrimitive().isString()) {
                        LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': remove must be a string primitive", pageId.m_135815_(), pageId.m_135827_()));
                        continue;
                    }
                    ResourceLocation pageToRemove = ResourceLocation.m_135820_((String)pageToRemoveElement.getAsJsonPrimitive().getAsString());
                    if (pageToRemove == null) continue;
                    boolean containsKeyFlag = false;
                    for (int i = pages.size() - 1; i >= 0; --i) {
                        if (!((EnergizedPowerBookScreen.PageContent)pages.get(i)).getPageId().equals((Object)pageToRemove)) continue;
                        containsKeyFlag = true;
                        pages.remove(i);
                        break;
                    }
                    if (containsKeyFlag) continue;
                    LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': page to be removed was not found", pageId.m_135815_(), pageId.m_135827_()));
                    continue;
                }
                MutableComponent chapterTitleComponent = null;
                if (object.has("title")) {
                    chapterTitleComponent = Component.Serializer.m_130691_((JsonElement)object.get("title"));
                }
                MutableComponent contentComponent = null;
                if (object.has("content")) {
                    contentComponent = Component.Serializer.m_130691_((JsonElement)object.get("content"));
                }
                ResourceLocation[] imageResourceLocations = null;
                if (object.has("image")) {
                    JsonElement imageElement = object.get("image");
                    if (imageElement.isJsonPrimitive()) {
                        if (!imageElement.getAsJsonPrimitive().isString()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': image must be a string primitive or an array of string primitives", pageId.m_135815_(), pageId.m_135827_()));
                            continue;
                        }
                        imageResourceLocations = new ResourceLocation[]{ResourceLocation.m_135820_((String)imageElement.getAsJsonPrimitive().getAsString())};
                    } else if (imageElement.isJsonArray()) {
                        JsonArray imageJsonArray = imageElement.getAsJsonArray();
                        if (imageJsonArray.isEmpty()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': Image array must contain at least one element", pageId.m_135815_(), pageId.m_135827_()));
                            continue;
                        }
                        ArrayList<ResourceLocation> imageResourceLocationList = new ArrayList<ResourceLocation>(imageJsonArray.size());
                        for (JsonElement imageJsonEle : imageJsonArray) {
                            if (!imageJsonEle.isJsonPrimitive() || !imageJsonEle.getAsJsonPrimitive().isString()) {
                                LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': image must be a string primitive or an array of string primitives", pageId.m_135815_(), pageId.m_135827_()));
                                continue block2;
                            }
                            imageResourceLocationList.add(ResourceLocation.m_135820_((String)imageJsonEle.getAsJsonPrimitive().getAsString()));
                        }
                        imageResourceLocations = imageResourceLocationList.toArray(new ResourceLocation[0]);
                    } else {
                        LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': image must be a string primitive or an array of string primitives", pageId.m_135815_(), pageId.m_135827_()));
                        continue;
                    }
                }
                ResourceLocation[] blockResourceLocations = null;
                if (object.has("block")) {
                    JsonElement blockElement = object.get("block");
                    if (blockElement.isJsonPrimitive()) {
                        if (!blockElement.getAsJsonPrimitive().isString()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': block must be a string primitive or an array of string primitives", pageId.m_135815_(), pageId.m_135827_()));
                            continue;
                        }
                        blockResourceLocations = new ResourceLocation[]{ResourceLocation.m_135820_((String)blockElement.getAsJsonPrimitive().getAsString())};
                    } else if (blockElement.isJsonArray()) {
                        JsonArray blockJsonArray = blockElement.getAsJsonArray();
                        if (blockJsonArray.isEmpty()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': Block array must contain at least one element", pageId.m_135815_(), pageId.m_135827_()));
                            continue;
                        }
                        ArrayList<ResourceLocation> blockResourceLocationsList = new ArrayList<ResourceLocation>(blockJsonArray.size());
                        for (JsonElement blockJsonEle : blockJsonArray) {
                            if (!blockJsonEle.isJsonPrimitive() || !blockJsonEle.getAsJsonPrimitive().isString()) {
                                LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': block must be a string primitive or an array of string primitives", pageId.m_135815_(), pageId.m_135827_()));
                                continue block2;
                            }
                            blockResourceLocationsList.add(ResourceLocation.m_135820_((String)blockJsonEle.getAsJsonPrimitive().getAsString()));
                        }
                        blockResourceLocations = blockResourceLocationsList.toArray(new ResourceLocation[0]);
                    } else {
                        LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': block must be a string primitive or an array of string primitives", pageId.m_135815_(), pageId.m_135827_()));
                        continue;
                    }
                }
                pages.add(new EnergizedPowerBookScreen.PageContent(pageId, (Component)chapterTitleComponent, (Component)contentComponent, imageResourceLocations, blockResourceLocations));
            }
            catch (Exception e) {
                LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s'", pageId.m_135815_(), pageId.m_135827_()), (Throwable)e);
            }
        }
        EnergizedPowerBookScreen.setPages(pages);
    }
}

