/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.LinkedList;
import java.util.List;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.integration.curios.CuriosCompatUtils;
import me.jddev0.ep.item.ActivatableItem;
import me.jddev0.ep.item.WorkingItem;
import me.jddev0.ep.item.energy.EnergizedPowerEnergyItem;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class InventoryCoalEngineItem
extends EnergizedPowerEnergyItem
implements ActivatableItem,
WorkingItem {
    public static final int CAPACITY = ModConfigs.COMMON_INVENTORY_COAL_ENGINE_CAPACITY.getValue();
    public static final int MAX_EXTRACT = ModConfigs.COMMON_INVENTORY_COAL_ENGINE_TRANSFER_RATE.getValue();
    public static final float ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_INVENTORY_COAL_ENGINE_ENERGY_PRODUCTION_MULTIPLIER.getValue().floatValue();

    public InventoryCoalEngineItem(Item.Properties props) {
        super(props, () -> new ExtractOnlyEnergyStorage(0, CAPACITY, MAX_EXTRACT));
    }

    @Override
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        boolean active = this.isActive(itemStack);
        components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.inventory_coal_engine.status").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("tooltip.energizedpower.inventory_coal_engine.status." + (active ? "activated" : "deactivated"))).m_130940_(active ? ChatFormatting.GREEN : ChatFormatting.RED)));
        if (Screen.m_96638_()) {
            int energyProductionLeft = this.getEnergyProductionLeft(itemStack);
            ItemStack item = this.getCurrentBurningItem(itemStack);
            if (energyProductionLeft > 0 && item != null) {
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.currently_burning").m_130940_(ChatFormatting.GRAY).m_7220_(item.m_41611_()));
                components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.energy_production_left", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(energyProductionLeft)}).m_130940_(ChatFormatting.GRAY));
            }
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.1").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.inventory_coal_engine.txt.shift.2").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
        }
    }

    private int addConsumerEnergyItem(List<IEnergyStorage> consumerItems, List<Integer> consumerEnergyValues, ItemStack itemStack, ItemStack testItemStack) {
        LazyOptional energyStorageLazyOptional = testItemStack.getCapability(ForgeCapabilities.ENERGY);
        if (!energyStorageLazyOptional.isPresent()) {
            return 0;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        if (!energyStorage.canReceive()) {
            return 0;
        }
        int received = energyStorage.receiveEnergy(Math.min(MAX_EXTRACT, InventoryCoalEngineItem.getEnergy(itemStack)), true);
        if (received <= 0) {
            return 0;
        }
        consumerItems.add(energyStorage);
        consumerEnergyValues.add(received);
        return received;
    }

    private void distributeEnergy(ItemStack itemStack, Level level, Inventory inventory, int slot, boolean selected) {
        LinkedList<IEnergyStorage> consumerItems = new LinkedList<IEnergyStorage>();
        LinkedList<Integer> consumerEnergyValues = new LinkedList<Integer>();
        int consumptionSum = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (i == slot) continue;
            ItemStack testItemStack = inventory.m_8020_(i);
            consumptionSum += this.addConsumerEnergyItem(consumerItems, consumerEnergyValues, itemStack, testItemStack);
        }
        List<ItemStack> curiosItemStacks = CuriosCompatUtils.getCuriosItemStacks(inventory);
        for (ItemStack testItemStack : curiosItemStacks) {
            consumptionSum += this.addConsumerEnergyItem(consumerItems, consumerEnergyValues, itemStack, testItemStack);
        }
        LinkedList<Integer> consumerEnergyDistributed = new LinkedList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(MAX_EXTRACT, Math.min(InventoryCoalEngineItem.getEnergy(itemStack), consumptionSum));
        InventoryCoalEngineItem.setEnergy(itemStack, InventoryCoalEngineItem.getEnergy(itemStack) - consumptionLeft);
        int divisor = consumerItems.size();
        block3: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block3;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(itemStack, level, entity, slot, selected);
        if (level.f_46443_) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        if (!this.isActive(itemStack)) {
            return;
        }
        Player player = (Player)entity;
        Inventory inventory = player.m_150109_();
        this.distributeEnergy(itemStack, level, inventory, slot, selected);
        int energyProductionLeft = this.getEnergyProductionLeft(itemStack);
        if (energyProductionLeft > 0) {
            int progress = this.getProgress(itemStack);
            int maxProgress = this.getMaxProgress(itemStack);
            ItemStack getCurrentBurningItem = this.getCurrentBurningItem(itemStack);
            if (progress >= 0 && maxProgress > 0 && progress < maxProgress && getCurrentBurningItem != null) {
                int energyProductionPerTick = energyProductionLeft / (maxProgress - progress);
                if (InventoryCoalEngineItem.getCapacity(itemStack) - InventoryCoalEngineItem.getEnergy(itemStack) < energyProductionPerTick) {
                    if (!this.isWorking(itemStack)) return;
                    itemStack.m_41784_().m_128379_("working", false);
                    return;
                }
                if (!this.isWorking(itemStack)) {
                    itemStack.m_41784_().m_128379_("working", true);
                }
                InventoryCoalEngineItem.setEnergy(itemStack, InventoryCoalEngineItem.getEnergy(itemStack) + energyProductionPerTick);
                itemStack.m_41784_().m_128405_("energy_production_left", energyProductionLeft - energyProductionPerTick);
                if (++progress != maxProgress) {
                    itemStack.m_41784_().m_128405_("progress", progress);
                    return;
                }
                this.resetProgress(itemStack);
            } else {
                this.resetProgress(itemStack);
            }
        }
        int i = 9;
        while (i < inventory.f_35974_.size()) {
            ItemStack testItemStack;
            int energyProduction;
            if (i != slot && (energyProduction = ForgeHooks.getBurnTime((ItemStack)(testItemStack = inventory.m_8020_(i)), null)) > 0) {
                energyProduction = (int)((float)energyProduction * ENERGY_PRODUCTION_MULTIPLIER);
                itemStack.m_41784_().m_128405_("energy_production_left", energyProduction);
                itemStack.m_41784_().m_128365_("item", (Tag)testItemStack.m_41739_(new CompoundTag()));
                itemStack.m_41784_().m_128405_("progress", 0);
                if (energyProduction / 100 <= MAX_EXTRACT) {
                    itemStack.m_41784_().m_128405_("max_progress", 100);
                } else {
                    itemStack.m_41784_().m_128405_("max_progress", (int)Math.ceil((float)energyProduction / (float)MAX_EXTRACT));
                }
                ItemStack newItemStack = testItemStack.m_41777_();
                newItemStack.m_41774_(1);
                inventory.m_6836_(i, newItemStack);
                if (!testItemStack.hasCraftingRemainingItem()) return;
                ItemStack craftingRemainingItem = testItemStack.getCraftingRemainingItem();
                if (!inventory.m_36054_(craftingRemainingItem)) return;
                player.m_36176_(craftingRemainingItem, false);
                return;
            }
            ++i;
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        itemStack.m_41784_().m_128379_("active", !this.isActive(itemStack));
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    private void resetProgress(ItemStack itemStack) {
        itemStack.m_41784_().m_128473_("energy_production_left");
        itemStack.m_41784_().m_128473_("progress");
        itemStack.m_41784_().m_128473_("max_progress");
        itemStack.m_41784_().m_128473_("item");
        if (this.isWorking(itemStack)) {
            itemStack.m_41784_().m_128379_("working", false);
        }
    }

    private int getProgress(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return -1;
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null || !nbt.m_128441_("progress")) {
            return -1;
        }
        return nbt.m_128451_("progress");
    }

    private int getMaxProgress(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return -1;
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null || !nbt.m_128441_("max_progress")) {
            return -1;
        }
        return nbt.m_128451_("max_progress");
    }

    private ItemStack getCurrentBurningItem(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return null;
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null || !nbt.m_128441_("item")) {
            return null;
        }
        return ItemStack.m_41712_((CompoundTag)nbt.m_128469_("item"));
    }

    private int getEnergyProductionLeft(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return -1;
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null || !nbt.m_128441_("energy_production_left")) {
            return -1;
        }
        return nbt.m_128451_("energy_production_left");
    }

    @Override
    public boolean isActive(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return false;
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null || !nbt.m_128441_("active")) {
            return false;
        }
        return nbt.m_128471_("active");
    }

    @Override
    public boolean isWorking(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return false;
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null || !nbt.m_128441_("working")) {
            return false;
        }
        return nbt.m_128471_("working");
    }
}

