/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.Locale;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.item.upgrade.UpgradeModuleItem;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class DurationUpgradeModuleItem
extends UpgradeModuleItem {
    private static final UpgradeModuleModifier[] UPGRADE_MODULE_MODIFIERS = new UpgradeModuleModifier[]{UpgradeModuleModifier.DURATION};
    private static final UpgradeModuleModifier[] UPGRADE_MODULE_MODIFIERS_TIER_6 = new UpgradeModuleModifier[]{UpgradeModuleModifier.DURATION, UpgradeModuleModifier.ENERGY_CONSUMPTION, UpgradeModuleModifier.ENERGY_TRANSFER_RATE};
    private static final double DURATION_1_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_DURATION_1_EFFECT.getValue();
    private static final double DURATION_2_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_DURATION_2_EFFECT.getValue();
    private static final double DURATION_3_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_DURATION_3_EFFECT.getValue();
    private static final double DURATION_4_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_DURATION_4_EFFECT.getValue();
    private static final double DURATION_5_EFFECT = ModConfigs.COMMON_UPGRADE_MODULE_DURATION_5_EFFECT.getValue();
    private static final double DURATION_6_ENERGY_CONSUMPTION_PER_TICK = ModConfigs.COMMON_UPGRADE_MODULE_DURATION_6_ENERGY_CONSUMPTION_PER_TICK.getValue().intValue();
    private static final double DURATION_6_ENERGY_TRANSFER_RATE = ModConfigs.COMMON_UPGRADE_MODULE_DURATION_6_ENERGY_TRANSFER_RATE.getValue();

    public DurationUpgradeModuleItem(Item.Properties props, int tier) {
        super(props, UpgradeModuleModifier.DURATION, tier);
    }

    @Override
    @NotNull
    public @NotNull UpgradeModuleModifier @NotNull [] getUpgradeModuleModifiers() {
        if (this.tier == 6) {
            return UPGRADE_MODULE_MODIFIERS_TIER_6;
        }
        return UPGRADE_MODULE_MODIFIERS;
    }

    @Override
    public double getUpgradeModuleModifierValue(UpgradeModuleModifier modifier) {
        return switch (modifier) {
            case UpgradeModuleModifier.DURATION -> {
                switch (this.tier) {
                    case 1: {
                        yield DURATION_1_EFFECT;
                    }
                    case 2: {
                        yield DURATION_2_EFFECT;
                    }
                    case 3: {
                        yield DURATION_3_EFFECT;
                    }
                    case 4: {
                        yield DURATION_4_EFFECT;
                    }
                    case 5: {
                        yield DURATION_5_EFFECT;
                    }
                    case 6: {
                        yield Double.POSITIVE_INFINITY;
                    }
                }
                yield -1.0;
            }
            case UpgradeModuleModifier.ENERGY_CONSUMPTION -> {
                if (this.tier == 6) {
                    yield DURATION_6_ENERGY_CONSUMPTION_PER_TICK;
                }
                yield -1.0;
            }
            case UpgradeModuleModifier.ENERGY_TRANSFER_RATE -> {
                if (this.tier == 6) {
                    yield DURATION_6_ENERGY_TRANSFER_RATE;
                }
                yield -1.0;
            }
            default -> -1.0;
        };
    }

    @Override
    public Component getUpgradeModuleModifierText(UpgradeModuleModifier modifier, double value) {
        return switch (modifier) {
            case UpgradeModuleModifier.DURATION -> {
                if (value == Double.POSITIVE_INFINITY) {
                    yield Component.m_237115_((String)"tooltip.energizedpower.infinite.txt").m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC});
                }
                yield Component.m_237113_((String)String.format(Locale.US, "\u2022 %.2f", value)).m_130940_(ChatFormatting.GREEN);
            }
            case UpgradeModuleModifier.ENERGY_CONSUMPTION -> Component.m_237115_((String)(EnergyUtils.getEnergyWithPrefix((int)value) + "/t")).m_130940_(ChatFormatting.RED);
            case UpgradeModuleModifier.ENERGY_TRANSFER_RATE -> Component.m_237113_((String)String.format(Locale.US, "%+.2f %%", 100.0 * value - 100.0)).m_130940_(ChatFormatting.GREEN);
            default -> Component.m_237119_();
        };
    }
}

