/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.SawmillRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SawmillCategory
implements IRecipeCategory<SawmillRecipe> {
    public static final ResourceLocation UID = EPAPI.id("sawmill");
    public static final RecipeType<SawmillRecipe> TYPE = new RecipeType(UID, SawmillRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public SawmillCategory(IGuiHelper helper) {
        ResourceLocation texture = EPAPI.id("textures/gui/container/sawmill.png");
        this.background = helper.createDrawable(texture, 42, 30, 109, 26);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EPBlocks.SAWMILL_ITEM.get()));
    }

    public RecipeType<SawmillRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"container.energizedpower.sawmill");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayout, SawmillRecipe recipe, IFocusGroup iFocusGroup) {
        iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 5).addIngredients(recipe.getInput());
        iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 65, 5).addItemStack(recipe.getOutput());
        iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 92, 5).addItemStacks(recipe.getSecondaryOutput().m_41619_() ? new ArrayList(0) : List.of(recipe.getSecondaryOutput()));
    }
}

