/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.List;
import java.util.Locale;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.PulverizerRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PulverizerCategory
implements IRecipeCategory<PulverizerRecipe> {
    public static final ResourceLocation UID = EPAPI.id("pulverizer");
    public static final RecipeType<PulverizerRecipe> TYPE = new RecipeType(UID, PulverizerRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public PulverizerCategory(IGuiHelper helper) {
        ResourceLocation texture = EPAPI.id("textures/gui/container/pulverizer.png");
        this.background = helper.createDrawable(texture, 42, 30, 109, 26);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EPBlocks.PULVERIZER_ITEM.get()));
    }

    public RecipeType<PulverizerRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"container.energizedpower.pulverizer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayout, PulverizerRecipe recipe, IFocusGroup iFocusGroup) {
        iRecipeLayout.addSlot(RecipeIngredientRole.INPUT, 1, 5).addIngredients(recipe.getInput());
        ItemStack[] outputEntries = recipe.getMaxOutputCounts(false);
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 65, 5).addItemStack(outputEntries[0])).addTooltipCallback((view, tooltip) -> {
            tooltip.add(Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages = recipe.getOutput().percentages();
            for (int i = 0; i < percentages.length; ++i) {
                tooltip.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
            }
        });
        ((IRecipeSlotBuilder)iRecipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 92, 5).addItemStacks(outputEntries[1].m_41619_() ? List.of() : List.of(outputEntries[1]))).addTooltipCallback((view, tooltip) -> {
            if (view.isEmpty()) {
                return;
            }
            tooltip.add(Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages = recipe.getSecondaryOutput().percentages();
            for (int i = 0; i < percentages.length; ++i) {
                tooltip.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
            }
        });
    }
}

