/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.Arrays;
import java.util.stream.Collectors;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.MetalPressRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MetalPressCategory
implements IRecipeCategory<MetalPressRecipe> {
    public static final ResourceLocation UID = EPAPI.id("metal_press");
    public static final RecipeType<MetalPressRecipe> TYPE = new RecipeType(UID, MetalPressRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public MetalPressCategory(IGuiHelper helper) {
        ResourceLocation texture = EPAPI.id("textures/gui/container/metal_press.png");
        this.background = helper.createDrawable(texture, 47, 22, 98, 34);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EPBlocks.CRUSHER_ITEM.get()));
    }

    public RecipeType<MetalPressRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"container.energizedpower.metal_press");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, MetalPressRecipe recipe, IFocusGroup iFocusGroup) {
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 1, 13).addItemStacks(Arrays.stream(recipe.getInput().m_43908_()).map(itemStack -> itemStack.m_255036_(recipe.getInputCount())).collect(Collectors.toList()));
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.CATALYST, 37, 1).addItemStack(recipe.getPressMold());
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 77, 13).addItemStack(recipe.getOutput());
    }
}

