/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.AlloyFurnaceBlockEntity;
import me.jddev0.ep.recipe.AlloyFurnaceRecipe;
import me.jddev0.ep.recipe.IngredientWithCount;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AlloyFurnaceCategory
implements IRecipeCategory<AlloyFurnaceRecipe> {
    public static final ResourceLocation UID = EPAPI.id("alloy_furnace");
    public static final RecipeType<AlloyFurnaceRecipe> TYPE = new RecipeType(UID, AlloyFurnaceRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public AlloyFurnaceCategory(IGuiHelper helper) {
        ResourceLocation texture = EPAPI.id("textures/gui/recipe/misc_gui.png");
        this.background = helper.createDrawable(texture, 1, 189, 147, 37);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EPBlocks.ALLOY_FURNACE_ITEM.get()));
    }

    public RecipeType<AlloyFurnaceRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"container.energizedpower.alloy_furnace");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, AlloyFurnaceRecipe recipe, IFocusGroup iFocusGroup) {
        int len = Math.min(recipe.getInputs().length, 3);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = recipe.getInputs()[i];
            iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 1 + 18 * i, 5).addItemStacks(Arrays.stream(input.input().m_43908_()).map(itemStack -> itemStack.m_255036_(input.count())).collect(Collectors.toList()));
        }
        ItemStack[] outputEntries = recipe.getMaxOutputCounts();
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 100, 5).addItemStack(outputEntries[0]);
        ((IRecipeSlotBuilder)iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 126, 5).addItemStacks(outputEntries[1].m_41619_() ? List.of() : List.of(outputEntries[1]))).addTooltipCallback((view, tooltip) -> {
            if (view.isEmpty()) {
                return;
            }
            tooltip.add(Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages = recipe.getSecondaryOutput().percentages();
            for (int i = 0; i < percentages.length; ++i) {
                tooltip.add(Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
            }
        });
    }

    public void draw(AlloyFurnaceRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        int ticks = (int)((float)recipe.getTicks() * AlloyFurnaceBlockEntity.RECIPE_DURATION_MULTIPLIER);
        MutableComponent component = Component.m_237110_((String)"recipes.energizedpower.info.ticks", (Object[])new Object[]{ticks});
        int textWidth = font.m_92852_((FormattedText)component);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)component, 147 - textWidth, 29, -1, false);
    }
}

