/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.FluidTransposerBlockEntity;
import me.jddev0.ep.recipe.FluidTransposerRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidTransposerEMIRecipe
implements EmiRecipe {
    public static final ResourceLocation SIMPLIFIED_TEXTURE = EPAPI.id("textures/block/fluid_transposer_front.png");
    public static final EmiStack ITEM = EmiStack.of((ItemLike)((ItemLike)EPBlocks.FLUID_TRANSPOSER_ITEM.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EPAPI.id("fluid_transposer"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final ResourceLocation id;
    private final FluidTransposerBlockEntity.Mode mode;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;

    public FluidTransposerEMIRecipe(FluidTransposerRecipe recipe) {
        this.id = recipe.m_6423_();
        this.mode = recipe.getMode();
        FluidStack fluid = recipe.getFluid();
        if (this.mode == FluidTransposerBlockEntity.Mode.EMPTYING) {
            this.input = List.of(EmiIngredient.of((Ingredient)recipe.getInput()));
            this.output = List.of(EmiStack.of((ItemStack)recipe.getOutput()), EmiStack.of((Fluid)fluid.getFluid(), (CompoundTag)fluid.getTag(), (long)fluid.getAmount()));
        } else {
            this.input = List.of(EmiIngredient.of((Ingredient)recipe.getInput()), EmiStack.of((Fluid)fluid.getFluid(), (CompoundTag)fluid.getTag(), (long)fluid.getAmount()));
            this.output = List.of(EmiStack.of((ItemStack)recipe.getOutput()));
        }
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 143;
    }

    public int getDisplayHeight() {
        return 26;
    }

    public void addWidgets(WidgetHolder widgets) {
        if (this.mode == FluidTransposerBlockEntity.Mode.EMPTYING) {
            widgets.addTexture(EPAPI.id("textures/gui/recipe/misc_gui.png"), 0, 0, 143, 26, 1, 133);
            widgets.addSlot(this.input.get(0), 0, 4).drawBack(false);
            widgets.addSlot((EmiIngredient)this.output.get(0), 63, 4).drawBack(false).recipeContext((EmiRecipe)this);
            widgets.addSlot((EmiIngredient)this.output.get(1), 89, 4).drawBack(false).recipeContext((EmiRecipe)this);
            widgets.addTexture(new ResourceLocation("minecraft", "textures/item/bucket.png"), 120, 5, 16, 16, 0, 0, 16, 16, 16, 16);
        } else {
            widgets.addTexture(EPAPI.id("textures/gui/recipe/misc_gui.png"), 0, 0, 143, 26, 1, 161);
            widgets.addSlot(this.input.get(0), 0, 4).drawBack(false);
            widgets.addSlot(this.input.get(1), 18, 4).drawBack(false);
            widgets.addSlot((EmiIngredient)this.output.get(0), 89, 4).drawBack(false).recipeContext((EmiRecipe)this);
            widgets.addTexture(new ResourceLocation("minecraft", "textures/item/water_bucket.png"), 120, 5, 16, 16, 0, 0, 16, 16, 16, 16);
        }
        widgets.addTooltipText(List.of(Component.m_237115_((String)("tooltip.energizedpower.fluid_transposer.mode." + this.mode.m_7912_()))), 118, 3, 20, 20);
    }
}

