/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.FiltrationPlantBlockEntity;
import me.jddev0.ep.fluid.EPFluids;
import me.jddev0.ep.recipe.FiltrationPlantRecipe;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class FiltrationPlantEMIRecipe
implements EmiRecipe {
    public static final ResourceLocation SIMPLIFIED_TEXTURE = EPAPI.id("textures/block/filtration_plant_front.png");
    public static final EmiStack ITEM = EmiStack.of((ItemLike)((ItemLike)EPBlocks.FILTRATION_PLANT_ITEM.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EPAPI.id("filtration_plant"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final OutputItemStackWithPercentages outputWithPercentages;
    private final OutputItemStackWithPercentages secondaryOutputWithPercentages;

    public FiltrationPlantEMIRecipe(FiltrationPlantRecipe recipe) {
        this.id = recipe.m_6423_();
        this.input = List.of(EmiStack.of((Fluid)((Fluid)EPFluids.DIRTY_WATER.get()), (long)FiltrationPlantBlockEntity.DIRTY_WATER_CONSUMPTION_PER_RECIPE));
        this.output = Arrays.stream(recipe.getMaxOutputCounts()).filter(itemStack -> !itemStack.m_41619_()).map(EmiStack::of).toList();
        this.outputWithPercentages = recipe.getOutput();
        this.secondaryOutputWithPercentages = recipe.getSecondaryOutput();
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 112;
    }

    public int getDisplayHeight() {
        return 26;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 28, 4);
        widgets.addSlot(this.input.get(0), 0, 4);
        SlotWidget outputSlot = widgets.addSlot((EmiIngredient)this.output.get(0), 63, 4).recipeContext((EmiRecipe)this);
        outputSlot.appendTooltip((Component)Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages"));
        double[] percentages = this.outputWithPercentages.percentages();
        for (int i = 0; i < percentages.length; ++i) {
            outputSlot.appendTooltip((Component)Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
        }
        SlotWidget secondaryOutputSlot = widgets.addSlot((EmiIngredient)(this.output.size() == 2 ? (EmiIngredient)this.output.get(1) : EmiStack.EMPTY), 91, 4).recipeContext((EmiRecipe)this);
        if (this.output.size() == 2) {
            secondaryOutputSlot.appendTooltip((Component)Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages2 = this.secondaryOutputWithPercentages.percentages();
            for (int i = 0; i < percentages2.length; ++i) {
                secondaryOutputSlot.appendTooltip((Component)Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages2[i])));
            }
        }
    }
}

