/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.AlloyFurnaceBlockEntity;
import me.jddev0.ep.recipe.AlloyFurnaceRecipe;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class AlloyFurnaceEMIRecipe
implements EmiRecipe {
    public static final ResourceLocation SIMPLIFIED_TEXTURE = EPAPI.id("textures/block/alloy_furnace_front.png");
    public static final EmiStack ITEM = EmiStack.of((ItemLike)((ItemLike)EPBlocks.ALLOY_FURNACE_ITEM.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EPAPI.id("alloy_furnace"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final OutputItemStackWithPercentages secondaryOutputWithPercentages;
    private final int ticks;

    public AlloyFurnaceEMIRecipe(AlloyFurnaceRecipe recipe) {
        this.id = recipe.m_6423_();
        this.input = Arrays.stream(recipe.getInputs()).map(input -> EmiIngredient.of((Ingredient)input.input(), (long)input.count())).collect(Collectors.toList());
        this.output = Arrays.stream(recipe.getMaxOutputCounts()).filter(itemStack -> !itemStack.m_41619_()).map(EmiStack::of).toList();
        this.secondaryOutputWithPercentages = recipe.getSecondaryOutput();
        this.ticks = (int)((float)recipe.getTicks() * AlloyFurnaceBlockEntity.RECIPE_DURATION_MULTIPLIER);
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 149;
    }

    public int getDisplayHeight() {
        return 39;
    }

    public void addWidgets(WidgetHolder widgets) {
        int i;
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 65, 4);
        int len = Math.min(this.input.size(), 3);
        for (i = 0; i < len; ++i) {
            widgets.addSlot(this.input.get(i), 18 * i, 4);
        }
        for (i = len; i < 3; ++i) {
            widgets.addSlot((EmiIngredient)EmiStack.EMPTY, 18 * i, 4);
        }
        widgets.addSlot((EmiIngredient)this.output.get(0), 98, 0).large(true).recipeContext((EmiRecipe)this);
        SlotWidget secondaryOutputSlot = widgets.addSlot((EmiIngredient)(this.output.size() == 2 ? (EmiIngredient)this.output.get(1) : EmiStack.EMPTY), 124, 0).large(true).recipeContext((EmiRecipe)this);
        if (this.output.size() == 2) {
            secondaryOutputSlot.appendTooltip((Component)Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages = this.secondaryOutputWithPercentages.percentages();
            for (int i2 = 0; i2 < percentages.length; ++i2) {
                secondaryOutputSlot.appendTooltip((Component)Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i2 + 1, 100.0 * percentages[i2])));
            }
        }
        MutableComponent ticksText = Component.m_237110_((String)"recipes.energizedpower.info.ticks", (Object[])new Object[]{this.ticks});
        FormattedCharSequence formattedCharSequence = ticksText.m_7532_();
        int n = widgets.getWidth() - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)ticksText);
        int n2 = widgets.getHeight();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        widgets.addText(formattedCharSequence, n, n2 - 9, ChatFormatting.WHITE.m_126665_().intValue(), false);
    }
}

