/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.fluid;

import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class InfinityFluidStorage
implements IFluidHandler {
    protected FluidStack fluid = FluidStack.EMPTY;

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.fluid;
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt).copy();
        if (!this.fluid.isEmpty()) {
            this.fluid.setAmount(Integer.MAX_VALUE);
        }
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        this.fluid.writeToNBT(nbt);
        return nbt;
    }

    public boolean isFluidValid(int tank, FluidStack fluidStack) {
        return true;
    }

    public void setFluid(FluidStack fluid) {
        if (fluid.isEmpty()) {
            this.fluid = FluidStack.EMPTY;
        } else {
            this.fluid = fluid.copy();
            this.fluid.setAmount(Integer.MAX_VALUE);
        }
        this.onChange();
    }

    protected void onChange() {
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return fluidStack.getAmount();
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return !fluidStack.isEmpty() && fluidStack.isFluidEqual(this.fluid) ? this.drain(fluidStack.getAmount(), fluidAction) : FluidStack.EMPTY;
    }

    public FluidStack drain(int amount, IFluidHandler.FluidAction fluidAction) {
        FluidStack fluid = this.fluid.copy();
        if (!fluid.isEmpty()) {
            fluid.setAmount(amount);
        }
        return fluid;
    }
}

