/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.energy;

import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;

public class ReceiveAndExtractEnergyStorage
implements IEnergizedPowerEnergyStorage {
    protected int energy;
    protected int capacity;
    protected int maxTransfer;

    public ReceiveAndExtractEnergyStorage() {
    }

    public ReceiveAndExtractEnergyStorage(int energy, int capacity, int maxTransfer) {
        this.energy = energy;
        this.capacity = capacity;
        this.maxTransfer = maxTransfer;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public void setEnergy(int energy) {
        this.energy = energy;
        this.onChange();
    }

    @Override
    public void setEnergyWithoutUpdate(int energy) {
        this.energy = energy;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
        this.onChange();
    }

    @Override
    public void setCapacityWithoutUpdate(int capacity) {
        this.capacity = capacity;
    }

    public int getMaxTransfer() {
        return this.maxTransfer;
    }

    public void setMaxTransfer(int maxTransfer) {
        this.maxTransfer = maxTransfer;
        this.onChange();
    }

    public void setMaxTransferWithoutUpdate(int maxTransfer) {
        this.maxTransfer = maxTransfer;
    }

    protected void onChange() {
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int received = Math.min(this.getMaxEnergyStored() - this.energy, Math.min(this.getMaxTransfer(), maxReceive));
        if (!simulate) {
            this.energy += received;
            this.onChange();
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int extracted = Math.min(this.energy, Math.min(this.getMaxTransfer(), maxExtract));
        if (!simulate) {
            this.energy -= extracted;
            this.onChange();
        }
        return extracted;
    }

    public final int getEnergyStored() {
        return this.getEnergy();
    }

    public final int getMaxEnergyStored() {
        return this.getCapacity();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public Tag saveNBT() {
        return IntTag.m_128679_((int)this.energy);
    }

    @Override
    public void loadNBT(Tag tag) {
        if (!(tag instanceof IntTag)) {
            this.energy = 0;
            return;
        }
        this.energy = ((IntTag)tag).m_7047_();
    }
}

