/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.datagen.recipe;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record ShapedFinishedRecipe(ResourceLocation id, String group, CraftingBookCategory category, Map<Character, Ingredient> key, String[] pattern, Item result, int count, Advancement.Builder advancement, ResourceLocation advancementId) implements FinishedRecipe
{
    public ShapedFinishedRecipe(ResourceLocation id, String group, CraftingBookCategory category, Map<Character, Ingredient> key, String[] pattern, ItemStack result, Advancement.Builder advancement, ResourceLocation advancementId) {
        this(id, group, category, key, pattern, result.m_41720_(), result.m_41613_(), advancement, advancementId);
    }

    public void m_7917_(JsonObject jsonObject) {
        this.verifyData();
        if (!this.group.isEmpty()) {
            jsonObject.addProperty("group", this.group);
        }
        jsonObject.addProperty("category", this.category.m_7912_());
        JsonArray patternJson = new JsonArray();
        for (String str : this.pattern) {
            patternJson.add(str);
        }
        jsonObject.add("pattern", (JsonElement)patternJson);
        JsonObject keyJson = new JsonObject();
        for (Map.Entry entry : this.key.entrySet()) {
            keyJson.add("" + entry.getKey(), ((Ingredient)entry.getValue()).m_43942_());
        }
        jsonObject.add("key", (JsonElement)keyJson);
        JsonObject resultJson = new JsonObject();
        resultJson.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
        if (this.count > 1) {
            resultJson.addProperty("count", (Number)this.count);
        }
        jsonObject.add("result", (JsonElement)resultJson);
    }

    public ResourceLocation m_6445_() {
        return this.id;
    }

    public RecipeSerializer<?> m_6637_() {
        return RecipeSerializer.f_44076_;
    }

    @Nullable
    public JsonObject m_5860_() {
        return this.advancement.m_138400_();
    }

    @Nullable
    public ResourceLocation m_6448_() {
        return this.advancementId;
    }

    private void verifyData() {
        if (this.pattern.length == 0) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + this.id + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String str : this.pattern) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + this.id + " uses undefined symbol '" + c + "'");
                }
                set.remove(Character.valueOf(c));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + this.id);
        }
        if (this.pattern.length == 1 && this.pattern[0].length() == 1) {
            throw new IllegalStateException("Shaped recipe " + this.id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }
}

