/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.datagen.generators;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import me.jddev0.ep.datagen.generators.PageContent;
import net.minecraft.ChatFormatting;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class PageContentProvider
implements DataProvider {
    private final Map<String, PageContent> data = new TreeMap<String, PageContent>();
    private final PackOutput output;
    private final String modid;
    private final ExistingFileHelper existingFileHelper;

    public PageContentProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        this.output = output;
        this.modid = modid;
        this.existingFileHelper = existingFileHelper;
    }

    protected abstract void registerPageContent();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.data.clear();
        this.registerPageContent();
        CompletableFuture[] futures = new CompletableFuture[this.data.size()];
        int i = 0;
        for (Map.Entry<String, PageContent> entry : this.data.entrySet()) {
            futures[i++] = this.savePageContent(cache, entry.getKey(), entry.getValue());
        }
        return CompletableFuture.allOf(futures);
    }

    private CompletableFuture<?> savePageContent(CachedOutput cache, String pageId, PageContent content) {
        Path target = this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(this.modid).resolve("book_pages").resolve(pageId + ".json");
        JsonObject json = content.toJson().getAsJsonObject();
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)target);
    }

    public String m_6055_() {
        return "Book Pages: " + this.modid;
    }

    protected MutableComponent addLinkToComponent(MutableComponent component, String link) {
        return component.m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}).m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, link)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"book.energizedpower.tooltip.link"))));
    }

    protected PageContent addSimplePage(String pageId, @Nullable Component content) {
        return this.addPage(pageId, null, content, null, null);
    }

    protected PageContent addSimplePage(String pageId, @Nullable Component content, @Nullable ResourceLocation image) {
        ResourceLocation[] resourceLocationArray;
        if (image == null) {
            resourceLocationArray = null;
        } else {
            ResourceLocation[] resourceLocationArray2 = new ResourceLocation[1];
            resourceLocationArray = resourceLocationArray2;
            resourceLocationArray2[0] = image;
        }
        return this.addPage(pageId, null, content, resourceLocationArray, null);
    }

    protected PageContent addSimplePage(String pageId, @Nullable Component content, @Nullable ResourceLocation[] image) {
        return this.addPage(pageId, null, content, image, null);
    }

    protected PageContent addSimplePage(String pageId, @Nullable Component content, Block block) {
        return this.addSimplePage(pageId, content, new Block[]{block});
    }

    protected PageContent addSimplePage(String pageId, @Nullable Component content, Block[] block) {
        ResourceLocation[] blockIds = new ResourceLocation[block.length];
        for (int i = 0; i < blockIds.length; ++i) {
            blockIds[i] = ForgeRegistries.BLOCKS.getKey((Object)block[i]);
        }
        return this.addPage(pageId, null, content, null, blockIds);
    }

    protected PageContent addChapterPage(String pageId, @Nullable Component title, @Nullable Component content, Block block) {
        return this.addChapterPage(pageId, title, content, new Block[]{block});
    }

    protected PageContent addChapterPage(String pageId, @Nullable Component title, @Nullable Component content, Block[] block) {
        ResourceLocation[] blockIds = new ResourceLocation[block.length];
        for (int i = 0; i < blockIds.length; ++i) {
            blockIds[i] = ForgeRegistries.BLOCKS.getKey((Object)block[i]);
        }
        return this.addPage(pageId, title, content, null, blockIds);
    }

    protected PageContent addChapterPage(String pageId, @Nullable Component title, @Nullable Component content) {
        return this.addChapterPage(pageId, title, content, (ResourceLocation[])null);
    }

    protected PageContent addChapterPage(String pageId, @Nullable Component title, @Nullable Component content, @Nullable ResourceLocation image) {
        ResourceLocation[] resourceLocationArray;
        if (image == null) {
            resourceLocationArray = null;
        } else {
            ResourceLocation[] resourceLocationArray2 = new ResourceLocation[1];
            resourceLocationArray = resourceLocationArray2;
            resourceLocationArray2[0] = image;
        }
        return this.addPage(pageId, title, content, resourceLocationArray, null);
    }

    protected PageContent addChapterPage(String pageId, @Nullable Component title, @Nullable Component content, @Nullable ResourceLocation[] image) {
        return this.addPage(pageId, title, content, image, null);
    }

    protected PageContent addPage(String pageId, @Nullable Component title, @Nullable Component content, @Nullable ResourceLocation[] image, @Nullable ResourceLocation[] block) {
        PageContent pageContent = new PageContent(new ResourceLocation(this.modid, pageId), title, content, image, block);
        this.data.put(pageId, pageContent);
        return pageContent;
    }
}

