/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.datagen.generators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public record PageContent(ResourceLocation pageId, Component chapterTitleComponent, Component pageComponent, ResourceLocation[] imageResourceLocations, ResourceLocation[] blockResourceLocations) {
    public PageContent(Component chapterTitleComponent, Component pageComponent, ResourceLocation[] imageResourceLocations, ResourceLocation[] blockResourceLocations) {
        this(null, chapterTitleComponent, pageComponent, imageResourceLocations, blockResourceLocations);
    }

    public PageContent withPageId(ResourceLocation pageId) {
        return new PageContent(pageId, this.chapterTitleComponent, this.pageComponent, this.imageResourceLocations, this.blockResourceLocations);
    }

    public JsonElement toJson() {
        JsonArray imageJson;
        JsonObject jsonObject = new JsonObject();
        if (this.chapterTitleComponent != null) {
            jsonObject.add("title", Component.Serializer.m_130716_((Component)this.chapterTitleComponent));
        }
        if (this.pageComponent != null) {
            jsonObject.add("content", Component.Serializer.m_130716_((Component)this.pageComponent));
        }
        if (this.imageResourceLocations != null) {
            if (this.imageResourceLocations.length == 1) {
                jsonObject.addProperty("image", this.imageResourceLocations[0].toString());
            } else {
                imageJson = new JsonArray();
                for (ResourceLocation imageResourceLocation : this.imageResourceLocations) {
                    imageJson.add(imageResourceLocation.toString());
                }
                jsonObject.add("image", (JsonElement)imageJson);
            }
        }
        if (this.blockResourceLocations != null) {
            if (this.blockResourceLocations.length == 1) {
                jsonObject.addProperty("block", this.blockResourceLocations[0].toString());
            } else {
                imageJson = new JsonArray();
                for (ResourceLocation blockResourceLocation : this.blockResourceLocations) {
                    imageJson.add(blockResourceLocation.toString());
                }
                jsonObject.add("block", (JsonElement)imageJson);
            }
        }
        return jsonObject;
    }
}

