/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.datagen;

import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.AlloyFurnaceBlock;
import me.jddev0.ep.block.CableBlock;
import me.jddev0.ep.block.ChargingStationBlock;
import me.jddev0.ep.block.EPBlockStateProperties;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.EnergizerBlock;
import me.jddev0.ep.block.FluidPipeBlock;
import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.block.ItemConveyorBeltBlock;
import me.jddev0.ep.block.ItemConveyorBeltSwitchBlock;
import me.jddev0.ep.block.LightningGeneratorBlock;
import me.jddev0.ep.block.TeleporterBlock;
import me.jddev0.ep.block.TransformerBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    private ModelFile itemConveyorBeltFlatTemplate;
    private ModelFile itemConveyorBeltAscendingTemplate;
    private ModelFile itemConveyorBeltDescendingTemplate;
    private ModelFile fluidPipeCoreTemplate;
    private ModelFile fluidPipeSideConnectedTemplate;
    private ModelFile fluidPipeSideExtractTemplate;
    private ModelFile fluidTankTemplate;
    private ModelFile cableCoreTemplate;
    private ModelFile cableSideTemplate;
    private ModelFile solarPanelTemplate;

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "energizedpower", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerTemplates();
        this.registerBlocks();
    }

    private void registerTemplates() {
        this.itemConveyorBeltFlatTemplate = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("item_conveyor_belt_flat_template")).ao(false)).element().from(0.0f, 1.0f, 0.0f).to(16.0f, 1.0f, 16.0f).face(Direction.DOWN).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#belt").end().face(Direction.UP).uvs(16.0f, 16.0f, 0.0f, 0.0f).texture("#belt").end().end();
        this.itemConveyorBeltAscendingTemplate = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("item_conveyor_belt_ascending_template")).ao(false)).element().from(0.0f, 9.0f, 0.0f).to(16.0f, 9.0f, 16.0f).rotation().origin(8.0f, 9.0f, 8.0f).axis(Direction.Axis.X).angle(-45.0f).rescale(true).end().face(Direction.DOWN).uvs(16.0f, 0.0f, 0.0f, 16.0f).texture("#belt").end().face(Direction.UP).uvs(16.0f, 16.0f, 0.0f, 0.0f).texture("#belt").end().end();
        this.itemConveyorBeltDescendingTemplate = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("item_conveyor_belt_descending_template")).ao(false)).element().from(0.0f, 9.0f, 0.0f).to(16.0f, 9.0f, 16.0f).rotation().origin(8.0f, 9.0f, 8.0f).axis(Direction.Axis.X).angle(-45.0f).rescale(true).end().face(Direction.DOWN).uvs(0.0f, 16.0f, 16.0f, 0.0f).texture("#belt").end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#belt").end().end();
        this.fluidPipeCoreTemplate = this.models().getExistingFile(EPAPI.id("fluid_pipe_core_template"));
        this.fluidPipeSideConnectedTemplate = this.models().getExistingFile(EPAPI.id("fluid_pipe_side_connected_template"));
        this.fluidPipeSideExtractTemplate = this.models().getExistingFile(EPAPI.id("fluid_pipe_side_extract_template"));
        this.fluidTankTemplate = this.models().getExistingFile(EPAPI.id("fluid_tank_template"));
        this.cableCoreTemplate = ((BlockModelBuilder)this.models().withExistingParent("cable_core_template", "block/thin_block")).element().from(6.0f, 6.0f, 6.0f).to(10.0f, 10.0f, 10.0f).face(Direction.DOWN).uvs(0.0f, 7.0f, 4.0f, 11.0f).cullface(Direction.DOWN).texture("#cable").end().face(Direction.UP).uvs(0.0f, 7.0f, 4.0f, 11.0f).cullface(Direction.UP).texture("#cable").end().face(Direction.NORTH).uvs(0.0f, 7.0f, 4.0f, 11.0f).cullface(Direction.NORTH).texture("#cable").end().face(Direction.SOUTH).uvs(0.0f, 7.0f, 4.0f, 11.0f).cullface(Direction.SOUTH).texture("#cable").end().face(Direction.WEST).uvs(0.0f, 7.0f, 4.0f, 11.0f).cullface(Direction.WEST).texture("#cable").end().face(Direction.EAST).uvs(0.0f, 7.0f, 4.0f, 11.0f).cullface(Direction.EAST).texture("#cable").end().end();
        this.cableSideTemplate = ((BlockModelBuilder)this.models().withExistingParent("cable_side_template", "block/thin_block")).element().from(6.0f, 6.0f, 0.0f).to(10.0f, 10.0f, 6.0f).face(Direction.DOWN).uvs(0.0f, 0.0f, 4.0f, 6.0f).texture("#cable").end().face(Direction.UP).uvs(0.0f, 0.0f, 4.0f, 6.0f).texture("#cable").end().face(Direction.NORTH).uvs(0.0f, 12.0f, 4.0f, 16.0f).texture("#cable").end().face(Direction.SOUTH).uvs(0.0f, 12.0f, 4.0f, 16.0f).texture("#cable").end().face(Direction.WEST).uvs(5.0f, 7.0f, 11.0f, 11.0f).texture("#cable").end().face(Direction.EAST).uvs(5.0f, 7.0f, 11.0f, 11.0f).texture("#cable").end().end();
        this.solarPanelTemplate = ((BlockModelBuilder)this.models().withExistingParent("solar_panel_template", "block/thin_block")).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 4.0f, 16.0f).face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).cullface(Direction.DOWN).texture("#side").end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#top").end().face(Direction.NORTH).uvs(0.0f, 12.0f, 16.0f, 16.0f).cullface(Direction.NORTH).texture("#side").end().face(Direction.SOUTH).uvs(0.0f, 12.0f, 16.0f, 16.0f).cullface(Direction.SOUTH).texture("#side").end().face(Direction.WEST).uvs(0.0f, 12.0f, 16.0f, 16.0f).cullface(Direction.WEST).texture("#side").end().face(Direction.EAST).uvs(0.0f, 12.0f, 16.0f, 16.0f).cullface(Direction.EAST).texture("#side").end().end();
    }

    private void registerBlocks() {
        this.cubeAllBlockWithItem(EPBlocks.SILICON_BLOCK);
        this.cubeAllBlockWithItem(EPBlocks.TIN_BLOCK);
        this.cubeAllBlockWithItem(EPBlocks.SAWDUST_BLOCK);
        this.cubeAllBlockWithItem(EPBlocks.TIN_ORE);
        this.cubeAllBlockWithItem(EPBlocks.DEEPSLATE_TIN_ORE);
        this.cubeAllBlockWithItem(EPBlocks.RAW_TIN_BLOCK);
        this.itemConveyorBeltBlockWithItem(EPBlocks.ITEM_CONVEYOR_BELT);
        this.orientableSixDirsBlockWithBackItem(EPBlocks.ITEM_CONVEYOR_BELT_LOADER, false);
        this.orientableBlockWithItem(EPBlocks.ITEM_CONVEYOR_BELT_SORTER, this.cubeBlockModel(EPBlocks.ITEM_CONVEYOR_BELT_SORTER, "", "_top", "_top", "_input", "_output_2", "_output_3", "_output_1"));
        this.activatableOrientableBlockWithItem(EPBlocks.ITEM_CONVEYOR_BELT_SWITCH, this.cubeBlockModel(EPBlocks.ITEM_CONVEYOR_BELT_SWITCH, "", "_top", "_top", "_input", "_side", "_output_disabled", "_output_enabled"), this.cubeBlockModel(EPBlocks.ITEM_CONVEYOR_BELT_SWITCH, "_powered", "_top", "_top", "_input", "_side", "_output_enabled", "_output_disabled"), ItemConveyorBeltSwitchBlock.POWERED);
        this.orientableBlockWithItem(EPBlocks.ITEM_CONVEYOR_BELT_SPLITTER, this.cubeBlockModel(EPBlocks.ITEM_CONVEYOR_BELT_SPLITTER, "", "_top", "_top", "_input", "_output", "_output", "_output"));
        this.orientableBlockWithItem(EPBlocks.ITEM_CONVEYOR_BELT_MERGER, this.cubeBlockModel(EPBlocks.ITEM_CONVEYOR_BELT_MERGER, "", "_top", "_top", "_output", "_input", "_input", "_input"));
        this.fluidPipeBlockWithItem(EPBlocks.IRON_FLUID_PIPE);
        this.fluidPipeBlockWithItem(EPBlocks.GOLDEN_FLUID_PIPE);
        this.fluidTankBlockWithItem(EPBlocks.FLUID_TANK_SMALL);
        this.fluidTankBlockWithItem(EPBlocks.FLUID_TANK_MEDIUM);
        this.fluidTankBlockWithItem(EPBlocks.FLUID_TANK_LARGE);
        this.fluidTankBlockWithItem(EPBlocks.CREATIVE_FLUID_TANK);
        this.cableBlockWithItem(EPBlocks.TIN_CABLE);
        this.cableBlockWithItem(EPBlocks.COPPER_CABLE);
        this.cableBlockWithItem(EPBlocks.GOLD_CABLE);
        this.cableBlockWithItem(EPBlocks.ENERGIZED_COPPER_CABLE);
        this.cableBlockWithItem(EPBlocks.ENERGIZED_GOLD_CABLE);
        this.cableBlockWithItem(EPBlocks.ENERGIZED_CRYSTAL_MATRIX_CABLE);
        this.transformerBlockWithItem(EPBlocks.LV_TRANSFORMER_1_TO_N);
        this.transformerBlockWithItem(EPBlocks.LV_TRANSFORMER_3_TO_3);
        this.transformerBlockWithItem(EPBlocks.LV_TRANSFORMER_N_TO_1);
        this.transformerBlockWithItem(EPBlocks.MV_TRANSFORMER_1_TO_N);
        this.transformerBlockWithItem(EPBlocks.MV_TRANSFORMER_3_TO_3);
        this.transformerBlockWithItem(EPBlocks.MV_TRANSFORMER_N_TO_1);
        this.transformerBlockWithItem(EPBlocks.HV_TRANSFORMER_1_TO_N);
        this.transformerBlockWithItem(EPBlocks.HV_TRANSFORMER_3_TO_3);
        this.transformerBlockWithItem(EPBlocks.HV_TRANSFORMER_N_TO_1);
        this.transformerBlockWithItem(EPBlocks.EHV_TRANSFORMER_1_TO_N);
        this.transformerBlockWithItem(EPBlocks.EHV_TRANSFORMER_3_TO_3);
        this.transformerBlockWithItem(EPBlocks.EHV_TRANSFORMER_N_TO_1);
        this.horizontalBlockWithItem(EPBlocks.BATTERY_BOX, true);
        this.horizontalBlockWithItem(EPBlocks.ADVANCED_BATTERY_BOX, true);
        this.horizontalBlockWithItem(EPBlocks.CREATIVE_BATTERY_BOX, true);
        this.horizontalTwoSideBlockWithItem(EPBlocks.PRESS_MOLD_MAKER, true);
        this.activatableOrientableBlockWithItem(EPBlocks.ALLOY_FURNACE, this.orientableBlockModel(EPBlocks.ALLOY_FURNACE, false), this.orientableOnBlockModel(EPBlocks.ALLOY_FURNACE, false), AlloyFurnaceBlock.LIT);
        this.horizontalTwoSideBlockWithItem(EPBlocks.AUTO_CRAFTER, true);
        this.horizontalTwoSideBlockWithItem(EPBlocks.ADVANCED_AUTO_CRAFTER, true);
        this.horizontalBlockWithItem(EPBlocks.CRUSHER, true);
        this.horizontalBlockWithItem(EPBlocks.ADVANCED_CRUSHER, true);
        this.horizontalBlockWithItem(EPBlocks.PULVERIZER, true);
        this.horizontalBlockWithItem(EPBlocks.ADVANCED_PULVERIZER, true);
        this.horizontalBlockWithItem(EPBlocks.SAWMILL, true);
        this.horizontalBlockWithItem(EPBlocks.COMPRESSOR, true);
        this.horizontalBlockWithItem(EPBlocks.METAL_PRESS, false);
        this.horizontalTwoSideBlockWithItem(EPBlocks.AUTO_PRESS_MOLD_MAKER, true);
        this.horizontalBlockWithItem(EPBlocks.AUTO_STONECUTTER, false);
        this.orientableBlockWithItem(EPBlocks.PLANT_GROWTH_CHAMBER, this.cubeBlockModel(EPBlocks.PLANT_GROWTH_CHAMBER, "", "_top", "_top", "_front", "_front", "_side", "_side"));
        this.orientableSixDirsBlockWithItem(EPBlocks.BLOCK_PLACER, true);
        this.orientableBlockWithItem(EPBlocks.ASSEMBLING_MACHINE, this.orientableBlockModel(EPBlocks.ASSEMBLING_MACHINE, false));
        this.activatableOrientableMachineBlockWithItem(EPBlocks.INDUCTION_SMELTER, false);
        this.horizontalBlockWithItem(EPBlocks.FLUID_FILLER, true);
        this.orientableBlockWithItem(EPBlocks.STONE_SOLIDIFIER, this.orientableBlockModel(EPBlocks.STONE_SOLIDIFIER, false));
        this.orientableBlockWithItem(EPBlocks.FLUID_TRANSPOSER, this.orientableBlockModel(EPBlocks.FLUID_TRANSPOSER, false));
        this.horizontalTwoSideBlockWithItem(EPBlocks.FILTRATION_PLANT, false);
        this.horizontalBlockWithItem(EPBlocks.FLUID_DRAINER, true);
        this.horizontalBlockWithItem(EPBlocks.FLUID_PUMP, false);
        this.horizontalBlockWithItem(EPBlocks.DRAIN, true);
        this.horizontalBlockWithItem(EPBlocks.CHARGER, true);
        this.horizontalBlockWithItem(EPBlocks.ADVANCED_CHARGER, true);
        this.horizontalBlockWithItem(EPBlocks.UNCHARGER, true);
        this.horizontalBlockWithItem(EPBlocks.ADVANCED_UNCHARGER, true);
        this.orientableSixDirsBlockWithItem(EPBlocks.MINECART_CHARGER, true);
        this.orientableSixDirsBlockWithItem(EPBlocks.ADVANCED_MINECART_CHARGER, true);
        this.orientableSixDirsBlockWithItem(EPBlocks.MINECART_UNCHARGER, true);
        this.orientableSixDirsBlockWithItem(EPBlocks.ADVANCED_MINECART_UNCHARGER, true);
        this.solarPanelBlockWithItem(EPBlocks.SOLAR_PANEL_1);
        this.solarPanelBlockWithItem(EPBlocks.SOLAR_PANEL_2);
        this.solarPanelBlockWithItem(EPBlocks.SOLAR_PANEL_3);
        this.solarPanelBlockWithItem(EPBlocks.SOLAR_PANEL_4);
        this.solarPanelBlockWithItem(EPBlocks.SOLAR_PANEL_5);
        this.solarPanelBlockWithItem(EPBlocks.SOLAR_PANEL_6);
        this.activatableOrientableMachineBlockWithItem(EPBlocks.COAL_ENGINE, false);
        this.poweredLampBlockWithItem(EPBlocks.POWERED_LAMP);
        this.activatableOrientableMachineBlockWithItem(EPBlocks.POWERED_FURNACE, false);
        this.activatableOrientableMachineBlockWithItem(EPBlocks.ADVANCED_POWERED_FURNACE, false);
        this.activatableBlockWithItem(EPBlocks.LIGHTNING_GENERATOR, this.cubeBlockModel(EPBlocks.LIGHTNING_GENERATOR, "", "_top", "_bottom", "_side", "_side", "_side", "_side"), this.cubeBlockModel(EPBlocks.LIGHTNING_GENERATOR, "_on", "_top_on", "_bottom", "_side_on", "_side_on", "_side_on", "_side_on"), LightningGeneratorBlock.HIT_BY_LIGHTNING_BOLT);
        this.activatableOrientableBlockWithItem(EPBlocks.ENERGIZER, this.orientableBlockModel(EPBlocks.ENERGIZER, true), this.orientableBlockModel(EPBlocks.ENERGIZER, "_on", "_top_on", "_bottom", "_front_on", "_side_on"), EnergizerBlock.LIT);
        this.activatableBlockWithItem(EPBlocks.CHARGING_STATION, this.cubeBlockModel(EPBlocks.CHARGING_STATION, "", "_top", "_bottom", "_side", "_side", "_side", "_side"), this.cubeBlockModel(EPBlocks.CHARGING_STATION, "_on", "_top_on", "_bottom", "_side_on", "_side_on", "_side_on", "_side_on"), ChargingStationBlock.CHARGING);
        this.horizontalBlockWithItem(EPBlocks.HEAT_GENERATOR, false);
        this.orientableBlockWithItem(EPBlocks.THERMAL_GENERATOR, this.orientableBlockModel(EPBlocks.THERMAL_GENERATOR, false));
        this.horizontalBlockWithItem(EPBlocks.CRYSTAL_GROWTH_CHAMBER, false);
        this.horizontalTwoSideBlockWithItem(EPBlocks.WEATHER_CONTROLLER, false);
        this.horizontalTwoSideBlockWithItem(EPBlocks.TIME_CONTROLLER, false);
        this.activatableBlockWithItem(EPBlocks.TELEPORTER, this.cubeBlockModel(EPBlocks.TELEPORTER, "", "_top", "_bottom", "_side", "_side", "_side", "_side"), this.cubeBlockModel(EPBlocks.TELEPORTER, "_ready", "_top_ready", "_bottom", "_side", "_side", "_side", "_side"), TeleporterBlock.POWERED);
        this.horizontalBlockWithItem(EPBlocks.BASIC_MACHINE_FRAME, false);
        this.horizontalBlockWithItem(EPBlocks.HARDENED_MACHINE_FRAME, false);
        this.horizontalBlockWithItem(EPBlocks.ADVANCED_MACHINE_FRAME, false);
        this.horizontalBlockWithItem(EPBlocks.REINFORCED_ADVANCED_MACHINE_FRAME, false);
    }

    private ModelFile cubeBlockModel(RegistryObject<? extends Block> block, String fileSuffix, String upSuffix, String bottomSuffix, String northSuffix, String southSuffix, String westSuffix, String eastSuffix) {
        ResourceLocation blockId = block.getId();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_() + fileSuffix, "block/cube")).texture("particle", "#up")).texture("up", this.getBlockTexture(block, upSuffix))).texture("down", this.getBlockTexture(block, bottomSuffix))).texture("north", this.getBlockTexture(block, northSuffix))).texture("south", this.getBlockTexture(block, southSuffix))).texture("west", this.getBlockTexture(block, westSuffix))).texture("east", this.getBlockTexture(block, eastSuffix));
    }

    private ModelFile orientableBlockModel(RegistryObject<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableBlockModel(block, "", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front", "_side");
    }

    private ModelFile orientableOnBlockModel(RegistryObject<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableBlockModel(block, "_on", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front_on", "_side");
    }

    private ModelFile orientableBlockModel(RegistryObject<? extends Block> block, String fileSuffix, String topSuffix, String bottomSuffix, String frontSuffix, String sideSuffix) {
        ResourceLocation blockId = block.getId();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_() + fileSuffix, "block/orientable")).texture("particle", "#top")).texture("top", this.getBlockTexture(block, topSuffix))).texture("bottom", this.getBlockTexture(block, bottomSuffix))).texture("front", this.getBlockTexture(block, frontSuffix))).texture("side", this.getBlockTexture(block, sideSuffix));
    }

    private ModelFile orientableWithBackBlockModel(RegistryObject<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableWithBackBlockModel(block, "", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front", "_back", "_side");
    }

    private ModelFile orientableWithBackBlockModel(RegistryObject<? extends Block> block, String fileSuffix, String topSuffix, String bottomSuffix, String frontSuffix, String backSuffix, String sideSuffix) {
        ResourceLocation blockId = block.getId();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_() + fileSuffix, "block/cube")).texture("particle", "#up")).texture("up", this.getBlockTexture(block, topSuffix))).texture("down", this.getBlockTexture(block, bottomSuffix))).texture("north", this.getBlockTexture(block, frontSuffix))).texture("south", this.getBlockTexture(block, backSuffix))).texture("west", this.getBlockTexture(block, sideSuffix))).texture("east", this.getBlockTexture(block, sideSuffix));
    }

    private ModelFile orientableVerticalWithBackBlockModel(RegistryObject<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableVerticalWithBackBlockModel(block, "_vertical", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front", "_back", "_side");
    }

    private ModelFile orientableVerticalWithBackBlockModel(RegistryObject<? extends Block> block, String fileSuffix, String topSuffix, String bottomSuffix, String frontSuffix, String backSuffix, String sideSuffix) {
        ResourceLocation blockId = block.getId();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_() + fileSuffix, "block/cube")).element().face(Direction.UP).cullface(Direction.UP).texture("#front").end().face(Direction.DOWN).uvs(0.0f, 16.0f, 16.0f, 0.0f).cullface(Direction.DOWN).texture("#back").end().face(Direction.NORTH).cullface(Direction.NORTH).texture("#top").end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture("#bottom").end().face(Direction.WEST).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).cullface(Direction.WEST).texture("#side").end().face(Direction.EAST).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).cullface(Direction.EAST).texture("#side").end().end()).texture("particle", "#top")).texture("top", this.getBlockTexture(block, topSuffix))).texture("bottom", this.getBlockTexture(block, bottomSuffix))).texture("front", this.getBlockTexture(block, frontSuffix))).texture("back", this.getBlockTexture(block, backSuffix))).texture("side", this.getBlockTexture(block, sideSuffix));
    }

    private ModelFile orientableVerticalBlockModel(RegistryObject<? extends Block> block, boolean uniqueBottomTexture) {
        return this.orientableVerticalBlockModel(block, "_vertical", "_top", uniqueBottomTexture ? "_bottom" : "_top", "_front", "_side");
    }

    private ModelFile orientableVerticalBlockModel(RegistryObject<? extends Block> block, String fileSuffix, String topSuffix, String bottomSuffix, String frontSuffix, String sideSuffix) {
        ResourceLocation blockId = block.getId();
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_() + fileSuffix, "block/orientable")).element().face(Direction.UP).cullface(Direction.UP).texture("#front").end().face(Direction.DOWN).uvs(0.0f, 16.0f, 16.0f, 0.0f).cullface(Direction.DOWN).texture("#side").end().face(Direction.NORTH).cullface(Direction.NORTH).texture("#top").end().face(Direction.SOUTH).cullface(Direction.SOUTH).texture("#bottom").end().face(Direction.WEST).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).cullface(Direction.WEST).texture("#side").end().face(Direction.EAST).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).cullface(Direction.EAST).texture("#side").end().end()).texture("particle", "#top")).texture("top", this.getBlockTexture(block, topSuffix))).texture("bottom", this.getBlockTexture(block, bottomSuffix))).texture("front", this.getBlockTexture(block, frontSuffix))).texture("side", this.getBlockTexture(block, sideSuffix));
    }

    private void cubeAllBlockWithItem(RegistryObject<? extends Block> block) {
        this.simpleBlockWithItem((Block)block.get(), this.cubeAll((Block)block.get()));
    }

    private void horizontalBlockWithItem(RegistryObject<? extends Block> block, boolean uniqueBottomTexture) {
        ResourceLocation blockId = block.getId();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_(), "block/cube")).texture("particle", "#up")).texture("up", this.getBlockTexture(block, "_top"))).texture("down", this.getBlockTexture(block, uniqueBottomTexture ? "_bottom" : "_top"))).texture("north", this.getBlockTexture(block, "_side"))).texture("south", this.getBlockTexture(block, "_side"))).texture("east", this.getBlockTexture(block, "_side"))).texture("west", this.getBlockTexture(block, "_side"));
        this.simpleBlockWithItem((Block)block.get(), (ModelFile)model);
    }

    private void horizontalTwoSideBlockWithItem(RegistryObject<? extends Block> block, boolean uniqueBottomTexture) {
        ResourceLocation blockId = block.getId();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_(), "block/cube")).texture("particle", "#up")).texture("up", this.getBlockTexture(block, "_top"))).texture("down", this.getBlockTexture(block, uniqueBottomTexture ? "_bottom" : "_top"))).texture("north", this.getBlockTexture(block, "_front"))).texture("south", this.getBlockTexture(block, "_side"))).texture("east", this.getBlockTexture(block, "_side"))).texture("west", this.getBlockTexture(block, "_front"));
        this.simpleBlockWithItem((Block)block.get(), (ModelFile)model);
    }

    private void orientableBlockWithItem(RegistryObject<? extends Block> block, ModelFile model) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).modelForState().modelFile(model).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).modelForState().rotationY(180).modelFile(model).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).modelForState().rotationY(90).modelFile(model).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).modelForState().rotationY(270).modelFile(model).addModel()).partialState();
        this.simpleBlockItem((Block)block.get(), model);
    }

    private void orientableSixDirsBlockWithBackItem(RegistryObject<? extends Block> block, boolean uniqueBottomTexture) {
        this.orientableSixDirsBlockWithItem(block, this.orientableWithBackBlockModel(block, uniqueBottomTexture), this.orientableVerticalWithBackBlockModel(block, uniqueBottomTexture));
    }

    private void orientableSixDirsBlockWithItem(RegistryObject<? extends Block> block, boolean uniqueBottomTexture) {
        this.orientableSixDirsBlockWithItem(block, this.orientableBlockModel(block, uniqueBottomTexture), this.orientableVerticalBlockModel(block, uniqueBottomTexture));
    }

    private void orientableSixDirsBlockWithItem(RegistryObject<? extends Block> block, ModelFile modelNormal, ModelFile modelVertical) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP).modelForState().modelFile(modelVertical).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN).modelForState().rotationX(180).modelFile(modelVertical).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH).modelForState().modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH).modelForState().rotationY(180).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST).modelForState().rotationY(90).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST).modelForState().rotationY(270).modelFile(modelNormal).addModel()).partialState();
        this.simpleBlockItem((Block)block.get(), modelNormal);
    }

    private void activatableBlockWithItem(RegistryObject<? extends Block> block, ModelFile modelNormal, ModelFile modelActive, BooleanProperty isActiveProperty) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelNormal).addModel()).partialState().with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelActive).addModel()).partialState();
        this.simpleBlockItem((Block)block.get(), modelNormal);
    }

    private void activatableOrientableBlockWithItem(RegistryObject<? extends Block> block, ModelFile modelNormal, ModelFile modelActive, BooleanProperty isActiveProperty) {
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(180).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(180).modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(90).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(90).modelFile(modelActive).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(false)).modelForState().rotationY(270).modelFile(modelNormal).addModel()).partialState().with((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST).with((Property)isActiveProperty, (Comparable)Boolean.valueOf(true)).modelForState().rotationY(270).modelFile(modelActive).addModel()).partialState();
        this.simpleBlockItem((Block)block.get(), modelNormal);
    }

    private void itemConveyorBeltBlockWithItem(RegistryObject<? extends ItemConveyorBeltBlock> block) {
        ResourceLocation blockId = block.getId();
        ModelBuilder modelFlat = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.m_135815_() + "_flat")).parent(this.itemConveyorBeltFlatTemplate)).texture("particle", "#belt")).texture("belt", this.getBlockTexture(block));
        ModelBuilder modelAscending = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.m_135815_() + "_ascending")).parent(this.itemConveyorBeltAscendingTemplate)).texture("particle", "#belt")).texture("belt", this.getBlockTexture(block));
        ModelBuilder modelDescending = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.m_135815_() + "_descending")).parent(this.itemConveyorBeltDescendingTemplate)).texture("particle", "#belt")).texture("belt", this.getBlockTexture(block));
        VariantBlockStateBuilder blockStateBuilder = this.getVariantBuilder((Block)block.get());
        for (EPBlockStateProperties.ConveyorBeltDirection beltDir : EPBlockStateProperties.ConveyorBeltDirection.values()) {
            ConfiguredModel.Builder configuredModelBuilder = blockStateBuilder.partialState().with(ItemConveyorBeltBlock.FACING, (Comparable)((Object)beltDir)).modelForState();
            if (beltDir.isAscending()) {
                switch (beltDir.getDirection()) {
                    case NORTH: {
                        configuredModelBuilder.rotationY(180);
                        break;
                    }
                    case WEST: {
                        configuredModelBuilder.rotationY(90);
                        break;
                    }
                    case EAST: {
                        configuredModelBuilder.rotationY(270);
                    }
                }
                configuredModelBuilder.modelFile((ModelFile)modelAscending).addModel();
                continue;
            }
            if (beltDir.isDescending()) {
                switch (beltDir.getDirection()) {
                    case SOUTH: {
                        configuredModelBuilder.rotationY(180);
                        break;
                    }
                    case WEST: {
                        configuredModelBuilder.rotationY(270);
                        break;
                    }
                    case EAST: {
                        configuredModelBuilder.rotationY(90);
                    }
                }
                configuredModelBuilder.modelFile((ModelFile)modelDescending).addModel();
                continue;
            }
            switch (beltDir.getDirection()) {
                case NORTH: {
                    configuredModelBuilder.rotationY(180);
                    break;
                }
                case WEST: {
                    configuredModelBuilder.rotationY(90);
                    break;
                }
                case EAST: {
                    configuredModelBuilder.rotationY(270);
                }
            }
            configuredModelBuilder.modelFile((ModelFile)modelFlat).addModel();
        }
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(blockId.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.getBlockTexture(block));
    }

    private void fluidPipeBlockWithItem(RegistryObject<? extends Block> block) {
        ResourceLocation blockId = block.getId();
        ModelBuilder fluidPipeCore = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.m_135815_() + "_core")).parent(this.fluidPipeCoreTemplate)).texture("particle", this.getBlockTexture(block, "_core"))).texture("fluid_pipe_core", this.getBlockTexture(block, "_core"));
        ModelBuilder fluidPipeSideConnected = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.m_135815_() + "_side_connected")).parent(this.fluidPipeSideConnectedTemplate)).texture("particle", this.getBlockTexture(block, "_side_connected"))).texture("fluid_pipe_side", this.getBlockTexture(block, "_side_connected"));
        ModelBuilder fluidPipeSideExtract = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.m_135815_() + "_side_extract")).parent(this.fluidPipeSideExtractTemplate)).texture("particle", this.getBlockTexture(block, "_side_outer_extract"))).texture("fluid_pipe_side_inner", this.getBlockTexture(block, "_side_inner_extract"))).texture("fluid_pipe_side_outer", this.getBlockTexture(block, "_side_outer_extract"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block.get()).part().modelFile((ModelFile)fluidPipeCore).addModel()).end().part().modelFile((ModelFile)fluidPipeSideConnected).rotationX(270).addModel()).condition(FluidPipeBlock.UP, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).rotationX(270).addModel()).condition(FluidPipeBlock.UP, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end().part().modelFile((ModelFile)fluidPipeSideConnected).rotationX(90).addModel()).condition(FluidPipeBlock.DOWN, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).rotationX(90).addModel()).condition(FluidPipeBlock.DOWN, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end().part().modelFile((ModelFile)fluidPipeSideConnected).addModel()).condition(FluidPipeBlock.NORTH, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).addModel()).condition(FluidPipeBlock.NORTH, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end().part().modelFile((ModelFile)fluidPipeSideConnected).rotationX(180).addModel()).condition(FluidPipeBlock.SOUTH, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).rotationX(180).addModel()).condition(FluidPipeBlock.SOUTH, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end().part().modelFile((ModelFile)fluidPipeSideConnected).rotationY(90).addModel()).condition(FluidPipeBlock.EAST, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).rotationY(90).addModel()).condition(FluidPipeBlock.EAST, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end().part().modelFile((ModelFile)fluidPipeSideConnected).rotationY(270).addModel()).condition(FluidPipeBlock.WEST, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.CONNECTED}).end().part().modelFile((ModelFile)fluidPipeSideExtract).rotationY(270).addModel()).condition(FluidPipeBlock.WEST, (Comparable[])new EPBlockStateProperties.PipeConnection[]{EPBlockStateProperties.PipeConnection.EXTRACT}).end();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(blockId.m_135815_())).parent((ModelFile)fluidPipeCore)).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 45.0f, 0.0f).end().transform(ItemDisplayContext.GROUND).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.FIXED).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).scale(0.65f, 0.65f, 0.65f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).scale(0.65f, 0.65f, 0.65f).end().end();
    }

    private void fluidTankBlockWithItem(RegistryObject<? extends Block> block) {
        ResourceLocation blockId = block.getId();
        ModelBuilder fluidTank = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.m_135815_())).parent(this.fluidTankTemplate)).texture("particle", "#up")).texture("front", this.getBlockTexture(block, "_front"))).texture("side", this.getBlockTexture(block, "_side"))).texture("up", this.getBlockTexture(block, "_top"))).texture("interior", this.getBlockTexture(block, "_interior"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)FluidTankBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)fluidTank).addModel()).partialState().with((Property)FluidTankBlock.FACING, (Comparable)Direction.SOUTH).modelForState().rotationY(180).modelFile((ModelFile)fluidTank).addModel()).partialState().with((Property)FluidTankBlock.FACING, (Comparable)Direction.EAST).modelForState().rotationY(90).modelFile((ModelFile)fluidTank).addModel()).partialState().with((Property)FluidTankBlock.FACING, (Comparable)Direction.WEST).modelForState().rotationY(270).modelFile((ModelFile)fluidTank).addModel()).partialState();
        this.simpleBlockItem((Block)block.get(), (ModelFile)fluidTank);
    }

    private void cableBlockWithItem(RegistryObject<? extends Block> block) {
        ResourceLocation blockId = block.getId();
        ModelBuilder cableCore = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.m_135815_() + "_core")).parent(this.cableCoreTemplate)).texture("particle", this.getBlockTexture(block))).texture("cable", this.getBlockTexture(block));
        ModelBuilder cableSide = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.m_135815_() + "_side")).parent(this.cableSideTemplate)).texture("particle", this.getBlockTexture(block))).texture("cable", this.getBlockTexture(block));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block.get()).part().modelFile((ModelFile)cableCore).addModel()).end().part().modelFile((ModelFile)cableSide).rotationX(270).addModel()).condition((Property)CableBlock.UP, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)cableSide).rotationX(90).addModel()).condition((Property)CableBlock.DOWN, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)cableSide).addModel()).condition((Property)CableBlock.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)cableSide).rotationX(180).addModel()).condition((Property)CableBlock.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)cableSide).rotationY(90).addModel()).condition((Property)CableBlock.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)cableSide).rotationY(270).addModel()).condition((Property)CableBlock.WEST, (Comparable[])new Boolean[]{true}).end();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(blockId.m_135815_())).parent((ModelFile)cableCore)).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 45.0f, 0.0f).scale(1.5f, 1.5f, 1.5f).end().transform(ItemDisplayContext.GROUND).scale(1.01f, 1.01f, 1.01f).end().transform(ItemDisplayContext.FIXED).scale(1.01f, 1.01f, 1.01f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).scale(1.01f, 1.01f, 1.01f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).scale(1.01f, 1.01f, 1.01f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).scale(1.01f, 1.01f, 1.01f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).scale(1.01f, 1.01f, 1.01f).end().end();
    }

    private void transformerBlockWithItem(RegistryObject<? extends TransformerBlock> block) {
        ResourceLocation blockId = block.getId();
        String textureName = switch (((TransformerBlock)((Object)block.get())).getTier()) {
            default -> throw new IncompatibleClassChangeError();
            case TransformerBlock.Tier.TIER_LV -> "lv_transformer";
            case TransformerBlock.Tier.TIER_MV -> "mv_transformer";
            case TransformerBlock.Tier.TIER_HV -> "hv_transformer";
            case TransformerBlock.Tier.TIER_EHV -> "ehv_transformer";
        };
        TransformerBlock.Type transformerType = ((TransformerBlock)((Object)block.get())).getTransformerType();
        switch (transformerType) {
            case TYPE_1_TO_N: 
            case TYPE_N_TO_1: {
                String singleSuffix = transformerType == TransformerBlock.Type.TYPE_1_TO_N ? "_input" : "_output";
                String multipleSuffix = transformerType == TransformerBlock.Type.TYPE_1_TO_N ? "_output" : "_input";
                ModelBuilder transformer = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_(), "block/orientable")).texture("particle", "#top")).texture("top", "block/" + textureName + multipleSuffix)).texture("bottom", "block/" + textureName + multipleSuffix)).texture("front", "block/" + textureName + singleSuffix)).texture("side", "block/" + textureName + multipleSuffix);
                ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.UP).modelForState().rotationX(270).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.DOWN).modelForState().rotationX(90).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.SOUTH).modelForState().rotationY(180).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.EAST).modelForState().rotationY(90).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.WEST).modelForState().rotationY(270).modelFile((ModelFile)transformer).addModel()).partialState();
                this.simpleBlockItem((Block)block.get(), (ModelFile)transformer);
                break;
            }
            case TYPE_3_TO_3: {
                ModelBuilder transformer = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockId.m_135815_(), "block/cube")).texture("particle", "#up")).texture("up", "block/" + textureName + "_input")).texture("down", "block/" + textureName + "_output")).texture("north", "block/" + textureName + "_input")).texture("south", "block/" + textureName + "_output")).texture("east", "block/" + textureName + "_output")).texture("west", "block/" + textureName + "_input");
                ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.UP).modelForState().rotationX(270).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.DOWN).modelForState().rotationX(90).rotationY(90).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.SOUTH).modelForState().rotationX(90).rotationY(180).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.EAST).modelForState().rotationY(90).modelFile((ModelFile)transformer).addModel()).partialState().with((Property)TransformerBlock.FACING, (Comparable)Direction.WEST).modelForState().rotationX(90).rotationY(270).modelFile((ModelFile)transformer).addModel()).partialState();
                this.simpleBlockItem((Block)block.get(), (ModelFile)transformer);
            }
        }
    }

    private void solarPanelBlockWithItem(RegistryObject<? extends Block> block) {
        ResourceLocation blockId = block.getId();
        ModelBuilder solarPanel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(blockId.m_135815_())).parent(this.solarPanelTemplate)).texture("particle", "#top")).texture("top", this.getBlockTexture(block, "_top"))).texture("side", this.getBlockTexture(block, "_side"));
        this.getVariantBuilder((Block)block.get()).partialState().modelForState().modelFile((ModelFile)solarPanel).addModel();
        this.simpleBlockItem((Block)block.get(), (ModelFile)solarPanel);
    }

    private void activatableOrientableMachineBlockWithItem(RegistryObject<? extends Block> block, boolean uniqueBottomTexture) {
        this.activatableOrientableBlockWithItem(block, this.orientableBlockModel(block, uniqueBottomTexture), this.orientableOnBlockModel(block, uniqueBottomTexture), BlockStateProperties.f_61443_);
    }

    private void poweredLampBlockWithItem(RegistryObject<? extends Block> block) {
        ResourceLocation blockId = block.getId();
        ModelBuilder modelOff = this.models().cubeAll(blockId.m_135815_(), this.getBlockTexture(block));
        ModelBuilder modelOn = this.models().cubeAll(blockId.m_135815_() + "_on", this.getBlockTexture(block, "_on"));
        VariantBlockStateBuilder blockStateBuilder = (VariantBlockStateBuilder)this.getVariantBuilder((Block)block.get()).partialState().with((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(0)).modelForState().modelFile((ModelFile)modelOff).addModel();
        for (int i = 1; i < 16; ++i) {
            blockStateBuilder.partialState().with((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(i)).modelForState().modelFile((ModelFile)modelOn).addModel();
        }
        this.simpleBlockItem((Block)block.get(), (ModelFile)modelOff);
    }

    private ResourceLocation getBlockTexture(RegistryObject<? extends Block> block) {
        ResourceLocation blockId = block.getId();
        return new ResourceLocation(blockId.m_135827_(), "block/" + blockId.m_135815_());
    }

    private ResourceLocation getBlockTexture(RegistryObject<? extends Block> block, String pathSuffix) {
        ResourceLocation blockId = block.getId();
        return new ResourceLocation(blockId.m_135827_(), "block/" + blockId.m_135815_() + pathSuffix);
    }
}

