/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config.value;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.ConfigValue;
import me.jddev0.ep.config.validation.ValueValidator;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceLocationListConfigValue
extends ConfigValue<List<ResourceLocation>> {
    public ResourceLocationListConfigValue(@NotNull String key, @NotNull @NotNull List<@NotNull ResourceLocation> defaultValue) {
        this(key, (String)null, defaultValue);
    }

    public ResourceLocationListConfigValue(@NotNull String key, @Nullable String comment, @NotNull @NotNull List<@NotNull ResourceLocation> defaultValue) {
        this(key, comment, defaultValue, (ValueValidator<List<ResourceLocation>>)null);
    }

    public ResourceLocationListConfigValue(@NotNull String key, @Nullable String comment, @NotNull @NotNull List<@NotNull ResourceLocation> defaultValue, @Nullable ValueValidator<List<@NotNull ResourceLocation>> customValidator) {
        super(key, comment, new ArrayList<ResourceLocation>(defaultValue), customValidator);
    }

    @Override
    @NotNull
    public List<String> getValidationCommentLines() {
        ArrayList<String> commentLines = new ArrayList<String>();
        commentLines.add("Syntax (whitespaces are ignored): [namespace1:path1, namespace2:path2, ...]");
        commentLines.addAll(super.getValidationCommentLines());
        return commentLines;
    }

    @Override
    public void validate(@NotNull @NotNull List<@NotNull ResourceLocation> value) throws ConfigValidationException {
        super.validate(value);
    }

    @Override
    @NotNull
    protected @NotNull List<@NotNull ResourceLocation> readInternal(@NotNull String rawValue) throws ConfigValidationException {
        if (rawValue.equals("[]")) {
            return new ArrayList<ResourceLocation>(0);
        }
        if (!rawValue.startsWith("[") || !rawValue.endsWith("]")) {
            throw new ConfigValidationException("List syntax: Must start with \"[\" and end with \"]\"");
        }
        if ((rawValue = rawValue.substring(1, rawValue.length() - 1).trim()).startsWith(",") || rawValue.endsWith(",")) {
            throw new ConfigValidationException("Value must not start with \"[,\" or end with \",]\"");
        }
        LinkedList<@NotNull ResourceLocation> resourceLocations = new LinkedList<ResourceLocation>();
        String[] tokens = rawValue.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].trim();
            if (token.isEmpty()) {
                throw new ConfigValidationException("Value must not be empty at index " + i);
            }
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)token);
            if (resourceLocation == null) {
                throw new ConfigValidationException("Invalid value at index " + i + ": \"" + token + "\"");
            }
            resourceLocations.add(resourceLocation);
        }
        return new ArrayList<ResourceLocation>(resourceLocations);
    }

    @Override
    @NotNull
    protected String writeInternal(@NotNull @NotNull List<@NotNull ResourceLocation> value) {
        StringBuilder builder = new StringBuilder("[");
        for (ResourceLocation resourceLocation : value) {
            builder.append(resourceLocation).append(", ");
        }
        if (!value.isEmpty()) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("]");
        return builder.toString();
    }
}

