/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config.value;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.ConfigValue;
import me.jddev0.ep.config.validation.ValueValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerConfigValue
extends ConfigValue<Integer> {
    private final int minInclusive;
    private final boolean minLenCheckEnabled;
    private final int maxInclusive;
    private final boolean maxLenCheckEnabled;

    public IntegerConfigValue(@NotNull String key, @NotNull Integer defaultValue) {
        this(key, (String)null, defaultValue);
    }

    public IntegerConfigValue(@NotNull String key, @Nullable String comment, @NotNull Integer defaultValue) {
        this(key, comment, defaultValue, (ValueValidator<? super Integer>)null);
    }

    public IntegerConfigValue(@NotNull String key, @Nullable String comment, @NotNull Integer defaultValue, @Nullable ValueValidator<? super Integer> customValidator) {
        this(key, comment, defaultValue, customValidator, null, null);
    }

    public IntegerConfigValue(@NotNull String key, @Nullable String comment, @NotNull Integer defaultValue, @Nullable Integer minInclusive, @Nullable Integer maxInclusive) {
        this(key, comment, defaultValue, null, minInclusive, maxInclusive);
    }

    public IntegerConfigValue(@NotNull String key, @Nullable String comment, @NotNull Integer defaultValue, @Nullable ValueValidator<? super Integer> customValidator, @Nullable Integer minInclusive, @Nullable Integer maxInclusive) {
        super(key, comment, defaultValue, customValidator);
        this.minLenCheckEnabled = minInclusive != null;
        this.minInclusive = this.minLenCheckEnabled ? minInclusive : 0;
        this.maxLenCheckEnabled = maxInclusive != null;
        this.maxInclusive = this.maxLenCheckEnabled ? maxInclusive : 0;
    }

    @Override
    @NotNull
    public List<String> getValidationCommentLines() {
        ArrayList<String> commentLines = new ArrayList<String>();
        if (this.minLenCheckEnabled) {
            commentLines.add("Value >= " + this.minInclusive);
        }
        if (this.maxLenCheckEnabled) {
            commentLines.add("Value <= " + this.maxInclusive);
        }
        commentLines.addAll(super.getValidationCommentLines());
        return commentLines;
    }

    @Override
    public void validate(@NotNull Integer value) throws ConfigValidationException {
        if (this.minLenCheckEnabled && value < this.minInclusive) {
            throw new ConfigValidationException("The value must be at least " + this.minInclusive);
        }
        if (this.maxLenCheckEnabled && value > this.maxInclusive) {
            throw new ConfigValidationException("The value must be at most " + this.maxInclusive);
        }
        super.validate(value);
    }

    @Override
    @NotNull
    protected Integer readInternal(@NotNull String rawValue) throws ConfigValidationException {
        try {
            return Integer.parseInt(rawValue);
        }
        catch (NumberFormatException e) {
            throw new ConfigValidationException("Invalid int value: " + e.getMessage());
        }
    }

    @Override
    @NotNull
    protected String writeInternal(@NotNull Integer value) {
        return "" + value;
    }
}

