/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.validation.ValueValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigValue<T> {
    @NotNull
    private final String key;
    @Nullable
    private final String comment;
    @NotNull
    private final T defaultValue;
    @NotNull
    private T value;
    private final ValueValidator<? super T> validator;
    private boolean loaded = false;

    public ConfigValue(@NotNull String key, @NotNull T defaultValue) {
        this(key, null, defaultValue);
    }

    public ConfigValue(@NotNull String key, @Nullable String comment, @NotNull T defaultValue) {
        this(key, comment, defaultValue, null);
    }

    public ConfigValue(@NotNull String key, @Nullable String comment, @NotNull T defaultValue, @Nullable ValueValidator<? super T> validator) {
        this.key = key;
        this.comment = comment;
        this.defaultValue = defaultValue;
        this.value = this.defaultValue;
        this.validator = validator;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @NotNull
    protected T getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public T getValue() {
        return this.value;
    }

    public void setValue(@NotNull T value) throws ConfigValidationException {
        this.validate(value);
        this.value = value;
    }

    @NotNull
    public List<String> getValidationCommentLines() {
        ArrayList<String> commentLines = new ArrayList<String>();
        if (this.validator != null) {
            commentLines.addAll(this.validator.getValidationCommentLines());
        }
        return commentLines;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    void manuallyLoaded() {
        this.loaded = true;
    }

    public void read(@NotNull String rawValue) throws ConfigValidationException {
        this.loaded = true;
        this.setValue(this.readInternal(rawValue));
    }

    @NotNull
    public String write() {
        return this.writeInternal(this.value);
    }

    @NotNull
    public String writeDefault() {
        return this.writeInternal(this.defaultValue);
    }

    public void validate(@NotNull T value) throws ConfigValidationException {
        if (this.validator != null) {
            this.validator.validate(value);
        }
    }

    @NotNull
    protected abstract T readInternal(@NotNull String var1) throws ConfigValidationException;

    @NotNull
    protected abstract String writeInternal(@NotNull T var1);
}

