/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.Optional;
import me.jddev0.ep.block.entity.base.UpgradableMenuProvider;
import me.jddev0.ep.block.entity.base.WorkerMachineBlockEntity;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleRecipeMachineBlockEntity<R extends Recipe<Container>>
extends WorkerMachineBlockEntity<R> {
    protected final UpgradableMenuProvider menuProvider;
    protected final RecipeType<R> recipeType;

    public SimpleRecipeMachineBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, UpgradableMenuProvider menuProvider, int slotCount, RecipeType<R> recipeType, int baseRecipeDuration, int baseEnergyCapacity, int baseEnergyTransferRate, int baseEnergyConsumptionPerTick, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, slotCount, baseRecipeDuration, baseEnergyCapacity, baseEnergyTransferRate, baseEnergyConsumptionPerTick, upgradeModifierSlots);
        this.menuProvider = menuProvider;
        this.recipeType = recipeType;
    }

    @Override
    protected ItemStackHandler initInventoryStorage() {
        return new ItemStackHandler(this.slotCount){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return slot == 0 && (SimpleRecipeMachineBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(SimpleRecipeMachineBlockEntity.this.f_58857_, SimpleRecipeMachineBlockEntity.this.recipeType, stack));
            }

            public void setStackInSlot(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    ItemStack itemStack = SimpleRecipeMachineBlockEntity.this.itemHandler.getStackInSlot(slot);
                    if (!(stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                        SimpleRecipeMachineBlockEntity.this.resetProgress();
                    }
                }
                super.setStackInSlot(slot, stack);
            }

            protected void onContentsChanged(int slot) {
                SimpleRecipeMachineBlockEntity.this.m_6596_();
            }
        };
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(SimpleRecipeMachineBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(SimpleRecipeMachineBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(SimpleRecipeMachineBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (SimpleRecipeMachineBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> SimpleRecipeMachineBlockEntity.this.redstoneMode.ordinal();
                    case 8 -> SimpleRecipeMachineBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        SimpleRecipeMachineBlockEntity.this.progress = ByteUtils.with2Bytes(SimpleRecipeMachineBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        SimpleRecipeMachineBlockEntity.this.maxProgress = ByteUtils.with2Bytes(SimpleRecipeMachineBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        SimpleRecipeMachineBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 8: {
                        SimpleRecipeMachineBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 9;
            }
        };
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        return this.menuProvider.createMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    protected Optional<R> getRecipeFor(Container inventory) {
        return this.f_58857_.m_7465_().m_44015_(this.recipeType, inventory, this.f_58857_);
    }

    @Override
    protected final Optional<R> getCurrentWorkData() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.getRecipeFor((Container)inventory);
    }

    @Override
    protected final double getWorkDataDependentWorkDuration(R workData) {
        return this.getRecipeDependentRecipeDuration(workData);
    }

    protected double getRecipeDependentRecipeDuration(R recipe) {
        return 1.0;
    }

    @Override
    protected final double getWorkDataDependentEnergyConsumption(R workData) {
        return this.getRecipeDependentEnergyConsumption(workData);
    }

    protected double getRecipeDependentEnergyConsumption(R recipe) {
        return 1.0;
    }

    @Override
    protected final boolean hasWork() {
        return this.hasRecipe();
    }

    protected boolean hasRecipe() {
        if (this.f_58857_ == null) {
            return false;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional<R> recipe = this.getRecipeFor((Container)inventory);
        return recipe.isPresent() && this.canCraftRecipe(inventory, (Recipe)recipe.get());
    }

    @Override
    protected final void onWorkStarted(R workData) {
        this.onStartCrafting(workData);
    }

    protected void onStartCrafting(R recipe) {
    }

    @Override
    protected final void onWorkCompleted(R workData) {
        this.craftItem(workData);
    }

    protected void craftItem(R recipe) {
        if (this.f_58857_ == null || !this.hasRecipe()) {
            return;
        }
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.setStackInSlot(1, recipe.m_8043_(this.f_58857_.m_9598_()).m_255036_(this.itemHandler.getStackInSlot(1).m_41613_() + recipe.m_8043_(this.f_58857_.m_9598_()).m_41613_()));
        this.resetProgress();
    }

    protected boolean canCraftRecipe(SimpleContainer inventory, R recipe) {
        return this.f_58857_ != null && InventoryUtils.canInsertItemIntoSlot((Container)inventory, 1, recipe.m_8043_(this.f_58857_.m_9598_()));
    }
}

