/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.base.UpgradableMenuProvider;
import me.jddev0.ep.block.entity.base.WorkerMachineBlockEntity;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncCurrentRecipeS2CPacket;
import me.jddev0.ep.recipe.ChangeCurrentRecipeIndexPacketUpdate;
import me.jddev0.ep.recipe.CurrentRecipePacketUpdate;
import me.jddev0.ep.recipe.SetCurrentRecipeIdPacketUpdate;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectableRecipeMachineBlockEntity<R extends Recipe<Container>>
extends WorkerMachineBlockEntity<R>
implements ChangeCurrentRecipeIndexPacketUpdate,
CurrentRecipePacketUpdate<R>,
SetCurrentRecipeIdPacketUpdate {
    protected final UpgradableMenuProvider menuProvider;
    protected final RecipeType<R> recipeType;
    protected final RecipeSerializer<R> recipeSerializer;
    protected ResourceLocation currentRecipeIdForLoad;
    protected R currentRecipe;

    public SelectableRecipeMachineBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, String machineName, UpgradableMenuProvider menuProvider, int slotCount, RecipeType<R> recipeType, RecipeSerializer<R> recipeSerializer, int baseRecipeDuration, int baseEnergyCapacity, int baseEnergyTransferRate, int baseEnergyConsumptionPerTick, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, slotCount, baseRecipeDuration, baseEnergyCapacity, baseEnergyTransferRate, baseEnergyConsumptionPerTick, upgradeModifierSlots);
        this.menuProvider = menuProvider;
        this.recipeType = recipeType;
        this.recipeSerializer = recipeSerializer;
    }

    @Override
    protected ContainerData initContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(SelectableRecipeMachineBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(SelectableRecipeMachineBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(SelectableRecipeMachineBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (SelectableRecipeMachineBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> SelectableRecipeMachineBlockEntity.this.redstoneMode.ordinal();
                    case 8 -> SelectableRecipeMachineBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        SelectableRecipeMachineBlockEntity.this.progress = ByteUtils.with2Bytes(SelectableRecipeMachineBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        SelectableRecipeMachineBlockEntity.this.maxProgress = ByteUtils.with2Bytes(SelectableRecipeMachineBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        SelectableRecipeMachineBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 8: {
                        SelectableRecipeMachineBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 9;
            }
        };
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.currentRecipe != null) {
            nbt.m_128365_("recipe.id", (Tag)StringTag.m_129297_((String)this.currentRecipe.m_6423_().toString()));
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("recipe.id")) {
            this.currentRecipeIdForLoad = ResourceLocation.m_135820_((String)nbt.m_128461_("recipe.id"));
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        this.syncEnergyToPlayer(player);
        this.syncCurrentRecipeToPlayer(player);
        return this.menuProvider.createMenu(id, inventory, this, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected final void onTickStart() {
        if (this.currentRecipeIdForLoad != null) {
            List recipes = this.f_58857_.m_7465_().m_44013_(this.recipeType);
            this.currentRecipe = recipes.stream().filter(recipe -> recipe.m_6423_().equals((Object)this.currentRecipeIdForLoad)).findFirst().orElse(null);
            this.currentRecipeIdForLoad = null;
        }
    }

    @Override
    protected Optional<R> getCurrentWorkData() {
        return Optional.ofNullable(this.currentRecipe);
    }

    @Override
    protected final double getWorkDataDependentWorkDuration(R workData) {
        return this.getRecipeDependentRecipeDuration(workData);
    }

    protected double getRecipeDependentRecipeDuration(R recipe) {
        return 1.0;
    }

    @Override
    protected final double getWorkDataDependentEnergyConsumption(R workData) {
        return this.getRecipeDependentEnergyConsumption(workData);
    }

    protected double getRecipeDependentEnergyConsumption(R recipe) {
        return 1.0;
    }

    @Override
    protected final boolean hasWork() {
        return this.hasRecipe();
    }

    protected boolean hasRecipe() {
        if (this.f_58857_ == null || this.currentRecipe == null) {
            return false;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.canCraftRecipe(inventory, this.currentRecipe);
    }

    @Override
    protected final void onWorkStarted(R workData) {
        this.onStartCrafting(workData);
    }

    protected void onStartCrafting(R recipe) {
    }

    @Override
    protected final void onWorkCompleted(R workData) {
        this.craftItem(workData);
    }

    protected abstract void craftItem(R var1);

    protected abstract boolean canCraftRecipe(SimpleContainer var1, R var2);

    @Override
    public void changeRecipeIndex(boolean downUp) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        List<Recipe> recipes = this.f_58857_.m_7465_().m_44013_(this.recipeType);
        recipes = recipes.stream().sorted(Comparator.comparing(recipe -> recipe.m_8043_(this.f_58857_.m_9598_()).m_41778_())).toList();
        int currentIndex = -1;
        if (this.currentRecipe != null) {
            for (int i = 0; i < recipes.size(); ++i) {
                if (!this.currentRecipe.m_6423_().equals((Object)recipes.get(i).m_6423_())) continue;
                currentIndex = i;
                break;
            }
        }
        if ((currentIndex += downUp ? 1 : -1) < -1) {
            currentIndex = recipes.size() - 1;
        } else if (currentIndex >= recipes.size()) {
            currentIndex = -1;
        }
        this.currentRecipe = currentIndex == -1 ? null : recipes.get(currentIndex);
        this.resetProgress();
        this.m_6596_();
        this.syncCurrentRecipeToPlayers(32);
    }

    @Override
    public void setRecipeId(ResourceLocation recipeId) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (recipeId == null) {
            this.currentRecipe = null;
        } else {
            List recipes = this.f_58857_.m_7465_().m_44013_(this.recipeType);
            Optional<Recipe> recipe = recipes.stream().filter(r -> r.m_6423_().equals((Object)recipeId)).findFirst();
            this.currentRecipe = recipe.orElse(null);
        }
        this.resetProgress();
        this.m_6596_();
        this.syncCurrentRecipeToPlayers(32);
    }

    protected final void syncCurrentRecipeToPlayer(Player player) {
        ModMessages.sendToPlayer(new SyncCurrentRecipeS2CPacket<R>(this.m_58899_(), this.recipeSerializer, this.currentRecipe), (ServerPlayer)player);
    }

    protected final void syncCurrentRecipeToPlayers(int distance) {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            ModMessages.sendToPlayersWithinXBlocks(new SyncCurrentRecipeS2CPacket<R>(this.m_58899_(), this.recipeSerializer, this.currentRecipe), this.m_58899_(), (ResourceKey<Level>)this.f_58857_.m_46472_(), distance);
        }
    }

    @Nullable
    public R getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public void setCurrentRecipe(@Nullable R currentRecipe) {
        this.currentRecipe = currentRecipe;
    }
}

